/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.upgrade;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.createcontent.exceptions.BlueprintPluginNotFoundException;
import com.atlassian.confluence.plugins.createcontent.services.TemplateUpdater;
import com.atlassian.confluence.plugins.createcontent.template.PluginPageTemplateHelper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceEditedTemplatesUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SpaceEditedTemplatesUpgradeTask.class);
    private final SpaceManager spaceManager;
    private final PluginPageTemplateHelper pluginPageTemplateHelper;
    private final TemplateUpdater templateUpdater;

    public SpaceEditedTemplatesUpgradeTask(SpaceManager spaceManager, PluginPageTemplateHelper pluginPageTemplateHelper, TemplateUpdater templateUpdater) {
        this.spaceManager = spaceManager;
        this.pluginPageTemplateHelper = pluginPageTemplateHelper;
        this.templateUpdater = templateUpdater;
    }

    public int getBuildNumber() {
        return 4;
    }

    public String getShortDescription() {
        return "Updates the content template reference of the content blueprint for user-edited templates.";
    }

    public Collection<Message> doUpgrade() {
        List allSpaces = this.spaceManager.getAllSpaces();
        for (Space space : allSpaces) {
            List<PageTemplate> templates = this.pluginPageTemplateHelper.getPageTemplates(space);
            this.updateBlueprintContentTemplates(templates);
        }
        return null;
    }

    private void updateBlueprintContentTemplates(List<PageTemplate> pageTemplates) {
        for (PageTemplate pageTemplate : pageTemplates) {
            try {
                this.templateUpdater.updateContentTemplateRef(pageTemplate);
            }
            catch (BlueprintPluginNotFoundException e) {
                log.warn("Page template '{}' (ID: {}) could not be migrated because a plugin was disabled. Cause: {}", new Object[]{pageTemplate.getTitle(), pageTemplate.getId(), e.getMessage()});
            }
        }
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-create-content-plugin";
    }
}

