/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.exceptions.ResourceException;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.plugins.createcontent.rest.PageTemplateForm;
import com.atlassian.confluence.plugins.createcontent.template.PluginPageTemplateHelper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/templates")
public class PageTemplateResource
extends AbstractRestResource {
    public static final String PARAM_ID = "id";
    public static final String PARAM_CONTENT_TEMPLATE_REF_ID = "contentTemplateRefId";
    private final PageTemplateManager pageTemplateManager;
    private final PluginPageTemplateHelper pageTemplateHelper;
    private final ContentTemplateRefManager contentTemplateRefManager;
    private final SpaceManager spaceManager;

    public PageTemplateResource(PageTemplateManager pageTemplateManager, PluginPageTemplateHelper pageTemplateHelper, ContentTemplateRefManager contentTemplateRefManager, SpaceManager spaceManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager) {
        super(permissionManager, spaceManager, spacePermissionManager);
        this.pageTemplateManager = pageTemplateManager;
        this.pageTemplateHelper = pageTemplateHelper;
        this.contentTemplateRefManager = contentTemplateRefManager;
        this.spaceManager = spaceManager;
    }

    @GET
    public PageTemplateForm get(@QueryParam(value="id") Integer id, @QueryParam(value="contentTemplateRefId") UUID contentTemplateRefId) {
        this.checkIds(id, contentTemplateRefId);
        if (id != null) {
            return this.build(this.getPageTemplate(id));
        }
        if (contentTemplateRefId != null) {
            return this.build(this.getPageTemplate(contentTemplateRefId));
        }
        throw new ResourceException("Either 'id' or 'contentTemplateRefId' parameter should be specified", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_MISSING);
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public long create(PageTemplateForm pageTemplate) {
        this.checkNullEntity(pageTemplate);
        PageTemplate newPageTemplate = this.build(pageTemplate);
        this.pageTemplateManager.savePageTemplate(newPageTemplate, null);
        return newPageTemplate.getId();
    }

    private PageTemplate build(PageTemplateForm pageTemplate) {
        PageTemplate result = new PageTemplate();
        result.setId(pageTemplate.id);
        result.setName(pageTemplate.name);
        result.setDescription(pageTemplate.description);
        result.setBodyType(BodyType.XHTML);
        if (!StringUtils.isEmpty((CharSequence)pageTemplate.spaceKey)) {
            Space space = this.spaceManager.getSpace(pageTemplate.spaceKey);
            result.setSpace(space);
        }
        result.setVersion(pageTemplate.version);
        result.setContent(pageTemplate.content);
        return result;
    }

    private PageTemplateForm build(PageTemplate pageTemplate) {
        PageTemplateForm result = new PageTemplateForm();
        result.id = pageTemplate.getId();
        result.name = pageTemplate.getName();
        result.description = pageTemplate.getDescription();
        Space space = pageTemplate.getSpace();
        if (space != null) {
            result.spaceKey = space.getKey();
        }
        result.version = pageTemplate.getVersion();
        result.content = pageTemplate.getContent();
        return result;
    }

    private void build(PageTemplateForm pageTemplate, PageTemplate originalPageTemplate) {
        if (!StringUtils.isEmpty((CharSequence)pageTemplate.name)) {
            originalPageTemplate.setName(pageTemplate.name);
        }
        if (!StringUtils.isEmpty((CharSequence)pageTemplate.description)) {
            originalPageTemplate.setDescription(pageTemplate.description);
        }
        if (!StringUtils.isEmpty((CharSequence)pageTemplate.content)) {
            originalPageTemplate.setContent(pageTemplate.content);
        }
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    public long update(PageTemplateForm pageTemplate) throws CloneNotSupportedException {
        PageTemplate originalPageTemplate = this.pageTemplateManager.getPageTemplate(pageTemplate.id);
        if (originalPageTemplate == null) {
            throw new ResourceException("Page template doesn't exist already", Response.Status.NOT_FOUND, ResourceErrorType.NOT_FOUND_PAGE_TEMPLATE, (Object)pageTemplate.id);
        }
        PageTemplate newPageTemplate = (PageTemplate)originalPageTemplate.clone();
        this.build(pageTemplate, originalPageTemplate);
        this.pageTemplateManager.savePageTemplate(originalPageTemplate, newPageTemplate);
        return newPageTemplate.getId();
    }

    @DELETE
    public void delete(@QueryParam(value="id") Integer id, @QueryParam(value="contentTemplateRefId") UUID contentTemplateRefId) {
        this.checkIds(id, contentTemplateRefId);
        PageTemplate pageTemplate = null;
        if (id != null) {
            pageTemplate = this.getPageTemplate(id);
        }
        if (contentTemplateRefId != null) {
            pageTemplate = this.getPageTemplate(contentTemplateRefId);
        }
        if (pageTemplate == null) {
            throw new ResourceException("The specified page template was not found", Response.Status.NOT_FOUND, ResourceErrorType.NOT_FOUND_PAGE_TEMPLATE);
        }
        this.pageTemplateManager.removePageTemplate(pageTemplate);
    }

    private void checkIds(Integer id, UUID contentTemplateRefId) {
        if (id == null && contentTemplateRefId == null) {
            throw new ResourceException("Either 'id' or 'contentTemplateRefId' parameter should be specified", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_MISSING);
        }
        if (id != null && contentTemplateRefId != null) {
            throw new ResourceException("Only one of 'id' or 'contentTemplateRefId' parameters should be specified", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_TOO_MANY);
        }
    }

    private PageTemplate getPageTemplate(UUID contentTemplateRefId) {
        ContentTemplateRef contentTemplateRef = (ContentTemplateRef)this.contentTemplateRefManager.getById(contentTemplateRefId);
        if (contentTemplateRef == null) {
            throw new ResourceException("The specified ContentTemplateRef was not found", Response.Status.NOT_FOUND, ResourceErrorType.NOT_FOUND_CONTENT_TEMPLATE_REF, (Object)contentTemplateRefId);
        }
        return this.pageTemplateHelper.getPageTemplate(contentTemplateRef);
    }

    private PageTemplate getPageTemplate(Integer id) {
        return this.pageTemplateManager.getPageTemplate((long)id.intValue());
    }
}

