/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.createcontent.services.UserStorageService;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class DefaultUserStorageService
implements UserStorageService {
    private final BandanaManager bandanaManager;
    private static final BandanaContext GLOBAL_DATA_CONTEXT = new ConfluenceBandanaContext(DefaultUserStorageService.class.getName());
    private final String SEPARATE_CHARACTER = ",";
    private final List<String> KEY_ACCEPTED = Arrays.asList("quick-create");

    public DefaultUserStorageService(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public boolean isKeyStoredForCurrentUser(String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || StringUtils.isEmpty((CharSequence)key) || !this.KEY_ACCEPTED.contains(key)) {
            return false;
        }
        Object users = this.bandanaManager.getValue(GLOBAL_DATA_CONTEXT, key);
        return users != null && users.toString().contains(user.getName() + ",");
    }

    @Override
    public void storeKeyForCurrentUser(String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || user.getName() == null || StringUtils.isEmpty((CharSequence)key) || !this.KEY_ACCEPTED.contains(key)) {
            throw new BadRequestException(Response.Status.BAD_REQUEST.getReasonPhrase());
        }
        Object users = this.bandanaManager.getValue(GLOBAL_DATA_CONTEXT, key);
        if (users == null || !users.toString().contains(user.getName() + ",")) {
            this.bandanaManager.setValue(GLOBAL_DATA_CONTEXT, key, (Object)(users + user.getName() + ","));
        }
    }
}

