/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.experimental;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintId;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintInstance;
import com.atlassian.confluence.api.service.content.ContentBlueprintService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.createcontent.extensions.UserBlueprintConfigManager;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/blueprint")
@ExperimentalApi
@PublicApi
public class ExperimentalContentBlueprintResource
extends AbstractRestResource {
    private final ContentBlueprintService contentBlueprintService;
    private final SettingsManager settingsManager;
    private final UserBlueprintConfigManager userBlueprintConfigManager;

    public ExperimentalContentBlueprintResource(PermissionManager permissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, SettingsManager settingsManager, UserBlueprintConfigManager userBlueprintConfigManager, ContentBlueprintService contentBlueprintService) {
        super(permissionManager, spaceManager, spacePermissionManager);
        this.settingsManager = settingsManager;
        this.userBlueprintConfigManager = userBlueprintConfigManager;
        this.contentBlueprintService = contentBlueprintService;
    }

    @POST
    @Path(value="{blueprintId}/instance")
    public ContentBlueprintInstance createInstance(ContentBlueprintInstance instance, @PathParam(value="blueprintId") ContentBlueprintId blueprintId, @QueryParam(value="expand") @DefaultValue(value="body.storage,history,space,version,ancestors") String expand) throws ServiceException {
        this.checkNullEntity(instance);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.contentBlueprintService.createInstance(instance, expansions);
    }
}

