package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Map;

/**
 * A REST Entity that represents the information needed to create a page from a Blueprint.
 */
public class CreateBlueprintPageRestEntity implements CreateBlueprintPageEntity {
    @JsonProperty
    private final String moduleCompleteKey;
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final String contentBlueprintId;
    @JsonProperty
    private final String contentTemplateId;
    @JsonProperty
    private final String contentTemplateKey;
    @JsonProperty
    private final String title;
    @JsonProperty
    private final String viewPermissionsUsers;
    @JsonProperty
    private final long parentPageId;
    @JsonProperty
    private final Map<String, Object> context;

    @JsonCreator
    public CreateBlueprintPageRestEntity(
            @JsonProperty("spaceKey") String spaceKey,
            @JsonProperty("contentBlueprintId") String contentBlueprintId,
            @JsonProperty("contentTemplateId") String contentTemplateId,
            @JsonProperty("contentTemplateKey") String contentTemplateKey,
            @JsonProperty("title") String title,
            @JsonProperty("viewPermissionsUsers") String viewPermissionsUsers,
            @JsonProperty("parentPageId") long parentPageId,
            @JsonProperty("moduleCompleteKey") String moduleCompleteKey,
            @JsonProperty("context") Map<String, Object> context) {
        this.spaceKey = spaceKey;
        this.contentBlueprintId = contentBlueprintId;
        this.contentTemplateId = contentTemplateId;
        this.contentTemplateKey = contentTemplateKey;
        this.title = title;
        this.viewPermissionsUsers = viewPermissionsUsers;
        this.parentPageId = parentPageId;
        this.moduleCompleteKey = moduleCompleteKey;
        this.context = context;
    }

    @Override
    public String getSpaceKey() {
        return spaceKey;
    }

    @Override
    public long getParentPageId() {
        return parentPageId;
    }

    @Override
    public String getModuleCompleteKey() {
        return moduleCompleteKey;
    }

    @Override
    public Map<String, Object> getContext() {
        return context;
    }

    @Override
    public String getContentBlueprintId() {
        return contentBlueprintId;
    }

    @Override
    public String getContentTemplateId() {
        return contentTemplateId;
    }

    @Override
    public String getContentTemplateKey() {
        return contentTemplateKey;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getViewPermissionsUsers() {
        return viewPermissionsUsers;
    }

    @Override
    public boolean equals(Object entity) {
        if (entity instanceof CreateBlueprintPageEntity) {
            CreateBlueprintPageEntity e = (CreateBlueprintPageEntity) entity;
            return this.title == e.getTitle();
        }

        return false;
    }
}
