package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.event.events.template.TemplateRemoveEvent;
import com.atlassian.confluence.event.events.template.TemplateUpdateEvent;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.services.PromotedTemplateService;
import com.atlassian.confluence.plugins.createcontent.services.TemplateUpdater;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import org.apache.commons.lang3.StringUtils;

public class TemplateUpdatedListener {
    private final TemplateUpdater templateUpdater;
    private final PromotedTemplateService promotedTemplateService;

    public TemplateUpdatedListener(TemplateUpdater templateUpdater, PromotedTemplateService promotedTemplateService) {
        this.templateUpdater = templateUpdater;
        this.promotedTemplateService = promotedTemplateService;
    }

    @EventListener
    public void onTempateUpdateEvent(TemplateUpdateEvent event) {
        PageTemplate newTemplate = event.getNewTemplate();
        PageTemplate oldTemplate = event.getOldTemplate();

        if (oldTemplate != null && (oldTemplate.getId() == newTemplate.getId()))
            return;   // the old and new templates are already referenced by the Content Blueprint

        // Update the blueprint content template reference in AO
        templateUpdater.updateContentTemplateRef(newTemplate);
    }

    @EventListener
    public void onTemplateRemoveEvent(TemplateRemoveEvent event) throws BlueprintIllegalArgumentException {
        PageTemplate template = event.getTemplate();
        Space space = template.getSpace();

        if (StringUtils.isBlank(template.getPluginKey()) && space != null) // space level user template
        {
            // Un promote template
            promotedTemplateService.demoteTemplate(template.getId(), space.getKey());
        }

        // Update the blueprint content template reference in AO
        templateUpdater.revertContentTemplateRef(template);
    }
}
