package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.plugins.createcontent.SpaceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;

public class RemoveSpaceListener {
    private final BandanaManager bandanaManager;

    public RemoveSpaceListener(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @EventListener
    public void onSpaceRemoveEvent(SpaceRemoveEvent event) {
        Space deletedSpace = event.getSpace();
        SpaceBandanaContext spaceBandanaContext = new SpaceBandanaContext(deletedSpace);

        // remove any all stored data for this space
        for (String key : bandanaManager.getKeys(spaceBandanaContext)) {
            bandanaManager.removeValue(spaceBandanaContext, key);
        }
    }
}
