package com.atlassian.confluence.plugins.createcontent.experimental;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintId;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintInstance;
import com.atlassian.confluence.api.service.content.ContentBlueprintService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.createcontent.extensions.UserBlueprintConfigManager;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;

import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

/**
 * This resource will be merged into Confluence.core after development is finished.
 * It will replace ContentBlueprintResource
 */
@PublicApi
@AnonymousAllowed
//@LimitRequestSize(LimitingRequestFilter.REQUEST_MAXSIZE_LARGE_BYTES)
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Path("/content/blueprint")
@ExperimentalApi
public class ExperimentalContentBlueprintResource extends AbstractRestResource {
    private final ContentBlueprintService contentBlueprintService;
    private final SettingsManager settingsManager;
    private final UserBlueprintConfigManager userBlueprintConfigManager;

    public ExperimentalContentBlueprintResource(PermissionManager permissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager,
                                                SettingsManager settingsManager,
                                                UserBlueprintConfigManager userBlueprintConfigManager,
                                                ContentBlueprintService contentBlueprintService) {
        super(permissionManager, spaceManager, spacePermissionManager);

        this.settingsManager = settingsManager;
        this.userBlueprintConfigManager = userBlueprintConfigManager;
        this.contentBlueprintService = contentBlueprintService;
    }

    /**
     * This method is put here temporally, will be moved to confluence core ContentBlueprintResource when done.
     * this method implements option A, B in the spec, Option C is already implemented in confluence core.
     * ContentBlueprintResource
     */
    @POST
    @Path("{blueprintId}/instance")
    public ContentBlueprintInstance createInstance(final ContentBlueprintInstance instance,
                                                   @PathParam("blueprintId") ContentBlueprintId blueprintId,
                                                   @QueryParam("expand") @DefaultValue("body.storage,history,space,version,ancestors") String expand)
            throws ServiceException {
        checkNullEntity(instance);

        final Expansion[] expansions = ExpansionsParser.parse(expand);
        return this.contentBlueprintService.createInstance(instance, expansions);
    }
}
