package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintDescriptor;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleCompleteKey;

import java.util.Map;

/**
 * Provides logic around Blueprints.
 *
 * @since 5.0
 */
public interface BlueprintManager {
    String PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-create-content-plugin";
    String FIRST_BLUEPRINT_FOR_USER = "firstBlueprintForUser";

    BlueprintDescriptor getBlueprintDescriptor(ModuleCompleteKey moduleCompleteKey);


    /**
     * Checks for and creates a index page if required for this blueprint, and pins it to the Space Sidebar.
     */
    @Deprecated
    Page createAndPinIndexPage(BlueprintDescriptor blueprintDescriptor, Space space);

    /**
     * Checks for and creates a index page if required for this blueprint, and pins it to the Space Sidebar.
     *
     * @param blueprint the type of blueprint the index page is being created for
     * @param space     the space to create the index page in
     * @return Page, or null if index page creation is disabled on the blueprint
     */
    Page createAndPinIndexPage(ContentBlueprint blueprint, Space space);

    /**
     * @param page the Confluence page to check for a blueprint
     * @return the fully-qualified blueprint descriptor key that the page was created with, or null if no Blueprint was
     * used.
     */
    String getBlueprintKeyForContent(AbstractPage page);

    @Deprecated
    String getIndexPageTitle(BlueprintDescriptor blueprintModuleDescriptor);

    String getIndexPageTitle(ContentBlueprint blueprint);

    /**
     * Creates a page from a Blueprint. The page will be created by the specified User under the specified parent page.
     */
    Page createBlueprintPage(ContentBlueprint blueprint, ConfluenceUser user, Space space, Page parentPage,
                             Map<String, Object> context);

    Page createPageFromTemplate(ContentTemplateRef contentTemplateRef, ConfluenceUser user, Space space, Page parentPage,
                                Map<String, Object> context);

    Page createPageFromTemplate(ContentTemplateRef contentTemplateRef, ConfluenceUser user, Space space, Page parentPage,
                                Map<String, Object> context, SaveContext saveContext);
}
