package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizard;
import com.atlassian.plugin.ModuleCompleteKey;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

/**
 * Provides SpaceBlueprints sourced from plugins.
 *
 * @since 2.0
 */
public interface PluginSpaceBlueprintAccessor {
    /**
     * Returns a SpaceBlueprint with the given key from the plugin system.
     */
    @Nonnull
    SpaceBlueprint getByModuleCompleteKey(@Nonnull ModuleCompleteKey moduleCompleteKey);

    /**
     * Returns the dialog of the specified Space Blueprint
     */
    @Nullable
    DialogWizard getDialogByModuleCompleteKey(@Nonnull ModuleCompleteKey moduleCompleteKey);

    /**
     * Returns all SpaceBlueprint from the plugin system.
     */
    @Nonnull
    List<SpaceBlueprint> getAll();
}
