package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.google.common.collect.Maps;

import java.util.Map;

public class BlueprintsTemplateRendererHelper implements TemplateRendererHelper {
    private TemplateRenderer templateRenderer;
    private static final String TEMPLATE_PROVIDER_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-create-content-plugin:all-resources";
    private static final String MACRO_TEMPLATE = "Confluence.Templates.Shared.macroXhtml.soy";

    public BlueprintsTemplateRendererHelper(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    @Override
    public String renderFromSoy(String pluginKey, String soyTemplate, Map<String, Object> soyContext) {
        StringBuilder output = new StringBuilder();
        templateRenderer.renderTo(output, pluginKey,
                soyTemplate, soyContext);
        return output.toString();
    }

    @Override
    public String renderMacroXhtml(String macroName, Map<String, String> parameters) {
        Map<String, Object> soyContext = Maps.newHashMap();
        soyContext.put("macroName", macroName);
        soyContext.put("parameters", parameters);
        return renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, MACRO_TEMPLATE, soyContext);
    }
}
