package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Component
public class DefaultPageTemplateGrouper implements PageTemplateGrouper {
    private final ContentBlueprintManager contentBlueprintManager;

    @Autowired
    public DefaultPageTemplateGrouper(ContentBlueprintManager contentBlueprintManager) {
        this.contentBlueprintManager = contentBlueprintManager;
    }

    @Override
    public Collection<ContentBlueprint> getSpaceContentBlueprints(@Nullable Space space) {
        List<ContentBlueprint> allGlobalContentBlueprints = contentBlueprintManager.getAll(null);
        Map<String, ContentBlueprint> result = Maps.newHashMap();

        for (ContentBlueprint blueprint : allGlobalContentBlueprints) {
            String moduleCompleteKey = blueprint.getModuleCompleteKey();
            if (!result.containsKey(moduleCompleteKey) || !blueprint.isPluginClone()) // add blueprint if it's not already added or if it's an updated version.
            {
                result.put(moduleCompleteKey, blueprint);
            }
        }

        if (space == null)
            return result.values();

        List<ContentBlueprint> spaceContentBlueprints = contentBlueprintManager.getAll(space);

        for (ContentBlueprint blueprint : spaceContentBlueprints) {
            result.put(blueprint.getModuleCompleteKey(), blueprint);
        }

        return result.values();
    }
}