package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;

/**
 * Stores and retrieves Create Request objects for use across multiple Http requests within a session.
 *
 * @since 2.0
 */
public interface RequestStorage {
    void storeCreateRequest(CreateBlueprintPageEntity createRequest, ContentEntityObject ceo);

    CreateBlueprintPageEntity retrieveRequest(ContentEntityObject ceo);

    void clear(ContentEntityObject draft);
}
