package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.plugins.createcontent.rest.ModuleCompleteKeyDeserializer;
import com.atlassian.confluence.plugins.createcontent.rest.ModuleCompleteKeySerializer;
import com.atlassian.plugin.ModuleCompleteKey;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Map;

/**
 * An Entity that represents the information needed to create a page from a Blueprint.
 */
@XmlRootElement
public class BlueprintPageEntity {
    @XmlElement
    String spaceKey;
    @XmlElement
    Long parentPageId;
    @XmlElement
    @JsonSerialize(contentUsing = ModuleCompleteKeySerializer.class)
    @JsonDeserialize(contentUsing = ModuleCompleteKeyDeserializer.class)
    ModuleCompleteKey moduleCompleteKey;
    @XmlElement
    Map<String, Object> context;

    // Should accept page permissions, like DraftData in core allows.
    // private PagePermissionData permissions;

    private BlueprintPageEntity() {
    }

    public BlueprintPageEntity(String spaceKey, Long parentPageId, ModuleCompleteKey moduleCompleteKey, Map<String, Object> context) {
        this.spaceKey = spaceKey;
        this.parentPageId = parentPageId;
        this.moduleCompleteKey = moduleCompleteKey;
        this.context = context;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public Long getParentPageId() {
        return parentPageId;
    }

    public ModuleCompleteKey getModuleCompleteKey() {
        return moduleCompleteKey;
    }

    public Map<String, Object> getContext() {
        return context;
    }

}
