package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.plugins.createcontent.rest.IconUrlProvider;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.atlassian.plugin.webresource.UrlMode.AUTO;
import static org.apache.commons.lang3.StringUtils.isBlank;

@Component
public class DefaultIconUrlProvider implements IconUrlProvider {
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Autowired
    public DefaultIconUrlProvider(final @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @Override
    public String getDefaultIconUrl() {
        return webResourceUrlProvider.getStaticPluginResourceUrl(
                "com.atlassian.confluence.plugins.confluence-create-content-plugin:resources",
                "images/preview-default-template.png",
                AUTO
        );
    }

    @Override
    public String getIconURL(final WebItemModuleDescriptor webItemModuleDescriptor) {
        final ResourceLocation resourceLocation = webItemModuleDescriptor.getResourceLocation("download", "icon");
        if (resourceLocation == null) {
            return getDefaultIconUrl();
        } else {
            final String iconFileName = resourceLocation.getName();
            if (isBlank(iconFileName)) {
                return getDefaultIconUrl();
            } else {
                final String moduleKey = webItemModuleDescriptor.getCompleteKey();
                return webResourceUrlProvider.getStaticPluginResourceUrl(moduleKey, iconFileName, AUTO);
            }
        }
    }
}
