package com.atlassian.confluence.plugins.createcontent.api.services;

import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;

/**
 * Manager to remove PII (Personally Identifiable Information) from {@link CreateBlueprintPageEntity}'s.
 * Implemented as part of GDPR compliance.
 *
 * @since 10.0.0
 */
public interface ContentBlueprintSanitiserManager {

    /**
     * Sanitise a {@link CreateBlueprintPageEntity} by replacing sensitive information in it with non-directly identifying information
     * e.g. userKeys instead of usernames.
     *
     * @param pageEntity The input {@link CreateBlueprintPageEntity} to cleanup.
     * @return the cleaned up entity.
     * @since 10.0.0
     */
    CreateBlueprintPageEntity sanitise(CreateBlueprintPageEntity pageEntity);

    /**
     * Un-sanitise a {@link CreateBlueprintPageEntity} with the real information
     * e.g. spaceKey in form of ~username
     *
     * @param entity the sanitised entity
     * @return the un-sanitised entity
     * @since 10.0.0
     */
    CreateBlueprintPageEntity unsanitise(CreateBlueprintPageEntity entity);
}
