package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.atlassian.confluence.spaces.Space;

import javax.annotation.Nullable;

import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * A context to group together all the plugin module state pertaining to a particular space.
 */
public class SpaceBandanaContext implements KeyedBandanaContext {
    private final Space space;

    public SpaceBandanaContext(Space space) {
        if (space == null) {
            throw new IllegalArgumentException("space is required");
        }

        if (isBlank(space.getKey())) {
            throw new IllegalArgumentException("space must have a non-empty spaceKey.");
        }

        this.space = space;
    }

    @Override
    public String getContextKey() {
        return "com.atlassian.confluence.blueprints.plugin-module-state:" + space.getKey();
    }

    @Nullable
    @Override
    public BandanaContext getParentContext() {
        return null;
    }

    @Override
    public boolean hasParentContext() {
        return false;
    }

    @Override
    public boolean equals(final Object that) {
        return that instanceof SpaceBandanaContext && this.getContextKey().equals(((SpaceBandanaContext) that).getContextKey());

    }

    @Override
    public int hashCode() {
        return getContextKey().hashCode();
    }
}
