package com.atlassian.confluence.plugins.createcontent.upgrade;

import com.atlassian.confluence.plugins.createcontent.BlueprintConstants;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintCleaner;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * Clean up content blueprints for removed spaces.
 *
 * @since 10.1.0
 */
@Component
@ExportAsService(PluginUpgradeTask.class)
public class ContentBlueprintsCleanUpUpgradeTask implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ContentBlueprintsCleanUpUpgradeTask.class);
    private final ContentBlueprintCleaner contentBlueprintCleaner;

    @Autowired
    public ContentBlueprintsCleanUpUpgradeTask(
            final ContentBlueprintCleaner contentBlueprintCleaner) {
        this.contentBlueprintCleaner = contentBlueprintCleaner;
    }

    /**
     * The build number for this upgrade task. Once this upgrade task has run the plugin manager will store this
     * build number against this plugin type.  After this only upgrade tasks with higher build numbers will be run
     */
    @Override
    public int getBuildNumber() {
        return 5;
    }

    @Override
    public String getShortDescription() {
        return "Clean up space-level content blueprints for removed spaces.";
    }

    @Override
    public Collection<Message> doUpgrade() {
        log.info("Deleting old content blueprints for removed spaces");
        contentBlueprintCleaner.cleanUp();
        return null;
    }

    @Override
    public String getPluginKey() {
        return BlueprintConstants.PLUGIN_KEY;
    }
}
