package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.plugins.createcontent.BlueprintStateController;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.confluence.plugins.createcontent.services.PromotedBlueprintService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;

import static com.atlassian.confluence.plugins.createcontent.BlueprintConstants.CREATE_DIALOG_CONTENT_SECTION;

public class ListContentBlueprintTemplatesContextProvider extends AbstractListBlueprintTemplatesContextProvider {
    private final ContextPathHolder contextPathHolder;
    private final I18nResolver i18nResolver;
    private final PageTemplateGrouper pageTemplateGrouper;
    private final BlueprintStateController blueprintStateController;
    private final PermissionManager permissionManager;
    private final PromotedBlueprintService promotedBlueprintService;

    public ListContentBlueprintTemplatesContextProvider(
            final @ComponentImport ContextPathHolder contextPathHolder,
            final @ComponentImport I18nResolver i18nResolver,
            final PageTemplateGrouper pageTemplateGrouper,
            final BlueprintStateController blueprintStateController,
            final @ComponentImport PermissionManager permissionManager,
            final PromotedBlueprintService promotedBlueprintService) {
        this.contextPathHolder = contextPathHolder;
        this.i18nResolver = i18nResolver;
        this.pageTemplateGrouper = pageTemplateGrouper;
        this.blueprintStateController = blueprintStateController;
        this.permissionManager = permissionManager;
        this.promotedBlueprintService = promotedBlueprintService;
    }

    @Override
    public Map<String, Object> getContextMap(final Map<String, Object> context) {
        final Object spaceObject = context.get("space");
        final Space space = spaceObject instanceof Space ? (Space) spaceObject : null;

        final ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        final Map<UUID, BlueprintState> blueprintStateMap =
                blueprintStateController.getAllContentBlueprintState(CREATE_DIALOG_CONTENT_SECTION, currentUser, space);
        final boolean isViewingSpaceTemplateAdmin = space != null;

        // Gets all blueprints for that context
        final Collection<ContentBlueprint> contentBlueprints = pageTemplateGrouper.getSpaceContentBlueprints(space);
        // Gets all blueprints to be displayed in the Admin page (enabled or disabled)
        final Collection<ContentBlueprint> displayedBlueprints = getDisplayableBlueprints(contentBlueprints, blueprintStateMap, isViewingSpaceTemplateAdmin);
        final Collection<ContentBlueprint> enabledBlueprints = getEnabledBlueprints(contentBlueprints, blueprintStateMap);

        context.put("enabledBlueprints", enabledBlueprints);
        context.put("contentBlueprints", displayedBlueprints);
        context.put("promotedBlueprints", promotedBlueprintService.getPromotedBlueprints(displayedBlueprints, space));

        context.put("contextPath", contextPathHolder.getContextPath());
        context.put("space", space);
        context.put("i18nResolver", i18nResolver);

        boolean canEnableDisableModules = permissionManager.hasPermission(currentUser, Permission.ADMINISTER,
                (isViewingSpaceTemplateAdmin ? space : PermissionManager.TARGET_APPLICATION));
        context.put("canEnableDisableModules", canEnableDisableModules);

        return context;
    }
}
