package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.plugins.createcontent.impl.PluginBackedBlueprint;
import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Collections2;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractListBlueprintTemplatesContextProvider implements ContextProvider {

    protected <T extends PluginBackedBlueprint> Collection<T> getEnabledBlueprints(Collection<T> blueprints, final Map<UUID, BlueprintState> blueprintStateMap) {
        return Collections2.filter(blueprints,
                input -> {
                    final UUID blueprintId = input.getId();
                    final BlueprintState blueprintState = blueprintStateMap.get(blueprintId);
                    return BlueprintState.FULLY_ENABLED.equals(blueprintState);
                });
    }

    protected <T extends PluginBackedBlueprint> Collection<T> getDisplayableBlueprints(Collection<T> blueprints, final Map<UUID, BlueprintState> blueprintStateMap, final boolean isViewingSpaceTemplateAdmin) {
        return Collections2.filter(blueprints,
                input -> {
                    final UUID blueprintId = input.getId();
                    final BlueprintState blueprintState = blueprintStateMap.get(blueprintId);

                    // Ignore blueprints that are added between the call to get state and the call to the grouper
                    if (blueprintState == null)
                        return false;

                    if (blueprintState.isDisabledInPluginSystem())
                        return false;

                    if (blueprintState.isDisabledByWebInterfaceManager())
                        return false;

                    //noinspection RedundantIfStatement
                    if (isViewingSpaceTemplateAdmin && blueprintState.isDisabledGlobally())
                        return false;

                    return true;
                });
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    public abstract Map<String, Object> getContextMap(Map<String, Object> context);
}
