package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.user.User;

/**
 *
 */
public interface UserStorageService {
    /**
     * Check if a particular key for the current user is stored
     *
     * @param key the key to check. Currently only 'quick-create' is supported.
     * @return
     */
    boolean isKeyStoredForCurrentUser(final String key);

    /**
     * Add provided key to the storage for current user
     *
     * @param key the key to store for this user. Currently only 'quick-create' is supported.
     */
    void storeKeyForCurrentUser(final String key);

    /**
     * Remove the key for a provided user.
     *
     * @param key  the key to remove. Currently only 'quick-create' is supported.
     * @param user the user to remove this key for
     */
    void removeKeyForUser(final String key, User user);
}
