package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.spaces.Space;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BlueprintLock {
    private final Object id;
    private final String spaceKey;

    public BlueprintLock(@Nonnull final Object id, @Nullable final Space space) {
        this.id = id;
        this.spaceKey = space != null ? space.getKey().toLowerCase() : null;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final BlueprintLock that = (BlueprintLock) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        return spaceKey != null ? spaceKey.equals(that.spaceKey) : that.spaceKey == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (spaceKey != null ? spaceKey.hashCode() : 0);
        return result;
    }
}