package com.atlassian.confluence.plugins.createcontent.spacecreationsteps;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;

import java.util.Map;

import static com.atlassian.confluence.security.SpacePermission.createUserSpacePermission;

public class RestrictedUserSpaceCreationStep extends AbstractSpaceCreationStep {
    private final SpacePermissionManager spacePermissionsManager;
    private final UserAccessor userAccessor;

    public static final String CONTEXT_KEY = "restrictedUsers";

    public RestrictedUserSpaceCreationStep(SpacePermissionManager spacePermissionsManager, UserAccessor userAccessor) {
        this.spacePermissionsManager = spacePermissionsManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public void posthandle(final Space space, final Map<String, Object> context) {
        final String users = (String) context.get(CONTEXT_KEY);
        if (users == null)
            return;

        spacePermissionsManager.createPrivateSpacePermissions(space);

        final String[] split = users.split(",");
        for (String username : split) {
            final ConfluenceUser user = userAccessor.getUserByName(username);
            if (user != null) {
                for (String permission : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                    if (permission.equals(SpacePermission.ADMINISTER_SPACE_PERMISSION) || permission.equals(SpacePermission.EXPORT_SPACE_PERMISSION))
                        continue;

                    spacePermissionsManager.savePermission(createUserSpacePermission(permission, space, user));
                }
            }
        }
    }
}
