package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.confluence.pages.templates.PageTemplate;

public interface TemplateUpdater {
    /**
     * Updates a content template reference of a blueprint in order to use a custom one.
     *
     * @param newTemplate user-defined custom template to be used when creating content from a blueprint,
     *                    instead of the default one bundled with the plugin
     */
    void updateContentTemplateRef(PageTemplate newTemplate);

    /**
     * Reverts a custom content template reference of a blueprint in order to use a default one.
     *
     * @param newTemplate user-defined custom template to be reverted so that the default one is used when creating content from a blueprint.
     */
    void revertContentTemplateRef(PageTemplate newTemplate);
}
