package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateDialogWebItemEntity;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.List;

/**
 * Sorts a collection of Blueprints into an order.
 *
 * @since 2.1
 */
public interface BlueprintSorter {
    List<CreateDialogWebItemEntity> sortContentBlueprintItems(@Nonnull Collection<CreateDialogWebItemEntity> items, @Nonnull Space space, ConfluenceUser user);

    List<CreateDialogWebItemEntity> sortSpaceBlueprintItems(@Nonnull List<CreateDialogWebItemEntity> pluginItems, ConfluenceUser user);
}
