package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Map;

/**
 * A REST Entity that represents the information needed to create a page from a Blueprint.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateBlueprintPageRestEntity implements CreateBlueprintPageEntity {
    @JsonProperty
    private final String moduleCompleteKey;
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final String contentBlueprintId;
    @JsonProperty
    private final String contentTemplateId;
    @JsonProperty
    private final String contentTemplateKey;
    @JsonProperty
    private final String title;
    @JsonProperty
    private final String viewPermissionsUsers;
    @JsonProperty
    private final long parentPageId;
    @JsonProperty
    private final Map<String, Object> context;
    @JsonProperty
    private final long spaceId;

    /**
     * @deprecated since 10.0
     */
    @Deprecated
    public CreateBlueprintPageRestEntity(
            String spaceKey,
            String contentBlueprintId,
            String contentTemplateId,
            String contentTemplateKey,
            String title,
            String viewPermissionsUsers,
            long parentPageId,
            String moduleCompleteKey,
            Map<String, Object> context) {
        this(
                spaceKey, contentBlueprintId, contentTemplateId, contentTemplateKey, title,
                viewPermissionsUsers, parentPageId, moduleCompleteKey, context, 0L
        );
    }

    @JsonCreator
    public CreateBlueprintPageRestEntity(
            @JsonProperty("spaceKey") String spaceKey,
            @JsonProperty("contentBlueprintId") String contentBlueprintId,
            @JsonProperty("contentTemplateId") String contentTemplateId,
            @JsonProperty("contentTemplateKey") String contentTemplateKey,
            @JsonProperty("title") String title,
            @JsonProperty("viewPermissionsUsers") String viewPermissionsUsers,
            @JsonProperty("parentPageId") long parentPageId,
            @JsonProperty("moduleCompleteKey") String moduleCompleteKey,
            @JsonProperty("context") Map<String, Object> context,
            @JsonProperty("spaceId") long spaceId) {
        this.spaceKey = spaceKey;
        this.contentBlueprintId = contentBlueprintId;
        this.contentTemplateId = contentTemplateId;
        this.contentTemplateKey = contentTemplateKey;
        this.title = title;
        this.viewPermissionsUsers = viewPermissionsUsers;
        this.parentPageId = parentPageId;
        this.moduleCompleteKey = moduleCompleteKey;
        this.context = context;
        this.spaceId = spaceId;
    }

    @Override
    public long getSpaceId() {
        return spaceId;
    }

    @Override
    public String getSpaceKey() {
        return spaceKey;
    }

    @Override
    public long getParentPageId() {
        return parentPageId;
    }

    @Override
    public String getModuleCompleteKey() {
        return moduleCompleteKey;
    }

    @Override
    public Map<String, Object> getContext() {
        return context;
    }

    @Override
    public String getContentBlueprintId() {
        return contentBlueprintId;
    }

    @Override
    public String getContentTemplateId() {
        return contentTemplateId;
    }

    @Override
    public String getContentTemplateKey() {
        return contentTemplateKey;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getViewPermissionsUsers() {
        return viewPermissionsUsers;
    }

    @Override
    public boolean equals(final Object entity) {
        if (entity instanceof CreateBlueprintPageEntity) {
            final CreateBlueprintPageEntity e = (CreateBlueprintPageEntity) entity;
            return this.title.equals(e.getTitle());
        }

        return false;
    }

    @Override
    public int hashCode() {
        return this.title.hashCode();
    }

    public static class Builder {
        private String moduleCompleteKey;
        private String spaceKey;
        private String contentBlueprintId;
        private String contentTemplateId;
        private String contentTemplateKey;
        private String title;
        private String viewPermissionsUsers;
        private long parentPageId;
        private Map<String, Object> context;
        private long spaceId;

        /**
         * Empty constructor
         */
        public Builder() {

        }

        public Builder(CreateBlueprintPageEntity entity) {
            this.spaceKey = entity.getSpaceKey();
            this.moduleCompleteKey = entity.getModuleCompleteKey();
            this.contentBlueprintId = entity.getContentBlueprintId();
            this.contentTemplateId = entity.getContentTemplateId();
            this.contentTemplateKey = entity.getContentTemplateKey();
            this.title = entity.getTitle();
            this.viewPermissionsUsers = entity.getViewPermissionsUsers();
            this.parentPageId = entity.getParentPageId();
            this.context = entity.getContext();
            this.spaceId = entity.getSpaceId();
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder spaceId(long spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder spaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder viewPermissionsUsers(String viewPermissionsUsers) {
            this.viewPermissionsUsers = viewPermissionsUsers;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public CreateBlueprintPageRestEntity build() {
            return new CreateBlueprintPageRestEntity(spaceKey, contentBlueprintId, contentTemplateId,
                    contentTemplateKey, title, viewPermissionsUsers, parentPageId, moduleCompleteKey, context, spaceId
            );
        }
    }
}
