package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintSpace;
import com.atlassian.confluence.spaces.Space;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * An Entity that contains details of a created Confluence Space. It encapsulates things.
 *
 * @since 2.0
 */
public class BlueprintSpaceEntity {
    @JsonProperty
    private String key;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String url;

    public BlueprintSpaceEntity() {
    }

    public BlueprintSpaceEntity(BlueprintSpace blueprintSpace, String baseUrl) {
        Space space = blueprintSpace.getSpace();
        key = space.getKey();
        name = space.getName();
        description = space.getDescription().getBodyAsString();
        url = baseUrl + space.getUrlPath();
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getUrl() {
        return url;
    }
}
