package com.atlassian.confluence.plugins.createcontent.contextproviders;

import com.atlassian.confluence.xwork.FlashScope;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

import static com.atlassian.confluence.plugins.createcontent.BlueprintConstants.CREATE_DIALOG_INIT_PARAMS_KEY;

public class CreateDialogInitParamsContextProvider implements ContextProvider {
    @Override
    public void init(Map<String, String> stringStringMap) throws PluginParseException {

    }

    @Override
    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map<String, String[]> parameterMap = (Map<String, String[]>) FlashScope.get(CREATE_DIALOG_INIT_PARAMS_KEY);

        if (parameterMap == null) {
            return context;
        }

        List<Pair<String, String>> params = Lists.newArrayList();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            params.add(new ImmutablePair<>(entry.getKey(), StringUtils.join(entry.getValue(), ',')));
        }
        context.put("params", params);

        return context;
    }
}
