package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.templates.actions.AbstractEditPageTemplateAction;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.atlassian.xwork.RequireSecurityToken;

public class RevertTemplateAction extends AbstractEditPageTemplateAction {
    @Override
    public void validate() {
        // nothing to do
    }

    @PermittedMethods({HttpMethod.GET, HttpMethod.POST})
    @RequireSecurityToken(true)
    public String doRemove() {
        PageTemplate template = pageTemplateManager.getPageTemplate(entityId);

        // triggers a TemplateRemovedEvent that is caught by the TemplateUpdatedListener
        pageTemplateManager.removePageTemplate(template);

        return SUCCESS + globalTemplateSuffix();
    }
}
