/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context.email;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.content.CommonContentExpansions;
import com.atlassian.confluence.notifications.content.ContentEditedPayload;
import com.atlassian.confluence.notifications.content.DiffContextProvider;
import com.atlassian.confluence.notifications.content.TransformerUtils;
import com.atlassian.confluence.notifications.content.context.AbstractCommentEditedRenderContextFactory;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class EmailCommentEditedRenderContextFactory
extends AbstractCommentEditedRenderContextFactory {
    private final DiffContextProvider diffContextProvider;

    public EmailCommentEditedRenderContextFactory(ContentService contentService, UserAccessor userAccessor, NotificationUserService notificationUserService, DiffContextProvider diffContextProvider) {
        super(contentService, userAccessor, notificationUserService);
        this.diffContextProvider = diffContextProvider;
    }

    @Override
    public Expansion[] getMediumSpecificExpansions() {
        return new Expansion[]{CommonContentExpansions.CONTAINER, CommonContentExpansions.SPACE, CommonContentExpansions.VERSION};
    }

    @Override
    public Maybe<Map<String, Object>> getMediumSpecificContext(Notification<ContentEditedPayload> notification, ServerConfiguration serverConfiguration, Either<NotificationAddress, RoleRecipient> roleRecipient, Content content) {
        ContentEditedPayload payload = (ContentEditedPayload)notification.getPayload();
        ContentId currentId = ContentId.of((ContentType)payload.getContentType(), (long)payload.getContentId());
        ContentId originalId = ContentId.of((ContentType)payload.getContentType(), (long)payload.getOriginalId());
        Option recipient = roleRecipient.right().toOption().map(TransformerUtils.toUserKey());
        HashMap context = Maps.newHashMap();
        context.put("inlineContext", payload.getInlineContext().getOrNull());
        Map<String, Object> diffContext = this.diffContextProvider.generateDiffContext(currentId, originalId, (Option<UserKey>)recipient);
        context.putAll(diffContext);
        return Option.some((Object)context);
    }
}

