/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context;

import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.notifications.content.FollowerPayload;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FollowerNotificationRenderContextFactory
extends RenderContextProviderTemplate<FollowerPayload> {
    private static final int MAX_FOLLOWERS_TO_DISPLAY = 9;
    private UserAccessor userAccessor;
    private FollowManager followManager;

    public FollowerNotificationRenderContextFactory(UserAccessor userAccessor, FollowManager followManager) {
        this.userAccessor = userAccessor;
        this.followManager = followManager;
    }

    protected Maybe<Map<String, Object>> checkedCreate(Notification<FollowerPayload> notification, ServerConfiguration serverConfiguration, Maybe<Either<NotificationAddress, RoleRecipient>> roleRecipient) {
        NotificationContext context = new NotificationContext();
        FollowerPayload payload = (FollowerPayload)notification.getPayload();
        ConfluenceUser follower = this.userAccessor.getUserByKey(new UserKey(payload.getFollower()));
        final ConfluenceUser userBeingFollowed = this.userAccessor.getExistingUserByKey(new UserKey(payload.getUserBeingFollowed()));
        Set unfiltered = this.followManager.getFollowing(follower);
        Iterable followingUserSet = com.google.common.collect.Iterables.filter((Iterable)unfiltered, (Predicate)Predicates.not((Predicate)new Predicate<ConfluenceUser>(){

            public boolean apply(@Nullable ConfluenceUser input) {
                return input.getKey().equals((Object)userBeingFollowed.getKey());
            }
        }));
        Iterable followingUsers = Iterables.take((int)9, (Iterable)followingUserSet);
        context.put("modifier", (Object)follower);
        context.put("followSubject", (Object)userBeingFollowed);
        context.put("listOfFollowing", (Object)followingUsers);
        context.put("notificationKey", (Object)notification.getKey());
        context.put("numberOfPeopleFollowing", (Object)com.google.common.collect.Iterables.size((Iterable)followingUserSet));
        return Option.some((Object)context.getMap());
    }
}

