/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.sizeof;

import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.sizeof.MaxDepthExceededException;
import org.ehcache.sizeof.Configuration;
import org.ehcache.sizeof.Size;
import org.ehcache.sizeof.SizeOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheSizeOfEngine
implements SizeOfEngine {
    private static final Logger LOG = LoggerFactory.getLogger((String)EhcacheSizeOfEngine.class.getName());
    private static final String VERBOSE_DEBUG_LOGGING = "net.sf.ehcache.sizeof.verboseDebugLogging";
    private static final boolean USE_VERBOSE_DEBUG_LOGGING = Boolean.getBoolean("net.sf.ehcache.sizeof.verboseDebugLogging");
    private final Configuration cfg;
    private final SizeOf sizeOf;

    public EhcacheSizeOfEngine(Configuration cfg) {
        this.cfg = cfg;
        this.sizeOf = SizeOf.newInstance(cfg.getFilters());
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public SizeOfEngine copyWith(int maxDepth, boolean abortWhenMaxDepthExceeded) {
        return new EhcacheSizeOfEngine(this.cfg);
    }

    public net.sf.ehcache.pool.Size sizeOf(Object key, Object value, Object container) {
        net.sf.ehcache.pool.Size size;
        try {
            Size ourSize = this.sizeOf.deepSizeOf(this.cfg.getMaxDepth(), this.cfg.isAbort(), key, value, container);
            size = new net.sf.ehcache.pool.Size(ourSize.getCalculated(), ourSize.isExact());
        }
        catch (MaxDepthExceededException e) {
            LOG.warn(e.getMessage());
            LOG.warn("key type: " + key.getClass().getName());
            LOG.warn("key: " + key);
            LOG.warn("value type: " + value.getClass().getName());
            LOG.warn("value: " + value);
            LOG.warn("container: " + container);
            size = new net.sf.ehcache.pool.Size(e.getMeasuredSize(), false);
        }
        if (USE_VERBOSE_DEBUG_LOGGING && LOG.isDebugEnabled()) {
            LOG.debug("size of {}/{}/{} -> {}", new Object[]{key, value, container, size.getCalculated()});
        }
        return size;
    }
}

