/**
 * CONFDEV-34947 Record every page transition which could have been replaced with a SPA transition
 */
define('confluence-browser-metrics/reporters/spa-transitions-reporter', [
    'jquery',
    'ajs',
    'confluence/storage-manager'
], function(
    $,
    AJS,
    StorageManager
) {

    var pendingReport = $.Deferred();

    var pageToPageTransitionKey = 'page-page';
    var dashboardToPageTransitionKey = 'dashboard-page';

    var storeManager = StorageManager('confluence', 'spa-transition');

    AJS.toInit(function () {
        $(document).on('click', 'a', clickHandler);

        // Check for any keys in localStorage
        var key = null;
        if (storeManager.doesContain(pageToPageTransitionKey)) {
            key = pageToPageTransitionKey;
        } else if (storeManager.doesContain(dashboardToPageTransitionKey)) {
            key = dashboardToPageTransitionKey;
        }

        if (key) {

            pendingReport.resolve({
                'confluence-spa-transition': key
            });

            storeManager.removeItem(key);

        } else {

            pendingReport.resolve({});

        }
    });

    function clickHandler(e) {
        var href = $(this).attr('href');

        if (href && isValidMouseClick(e) && isViewPage(href)) {
            storeManager.setItemQuietly(isDashboard() ? dashboardToPageTransitionKey : pageToPageTransitionKey, true, 300);
        }

        return true;
    }

    function isValidMouseClick(e) {
        return e.which === 1 &&   // Left mouse button
            !e.metaKey &&         // Not holding meta key
            !e.ctrlKey &&         // Not holding control key
            !e.shiftKey;          // Not holding shift key
    }

    function isViewPage(href) {
        return (href.indexOf('/display/') !== -1 ||                    // /wiki/display/DS/Some+Page
            isNewViewPageRoute(href) ||                                // /wiki/spaces/CONFDEV/pages/1233242/Title
            href.indexOf('/viewpage.action') !== -1) &&                // /wiki/pages/viewpage.action?pageId=294920
            (href.indexOf('~') === -1 || isPersonalSpacePage(href));   // /wiki/display/~jmcarthur/Some+Page
    }

    function isPersonalSpacePage(href) {
        return (href.indexOf('/', href.indexOf('~') + 1) !== -1) && href.slice(-1) !== '/';
    }

    // Routes migration may be rolled out before SPA
    function isNewViewPageRoute(href) {
        // matches spaces/SPACEKEY/pages/PAGEID and spaces/SPACEKEY/pages/PAGEID/PAGESLUG
        return /spaces\/(.*)\/pages\/(.*)/.test(href);
    }

    function isDashboard() {
        return $('body').hasClass('dashboard');
    }

    var spaTransitionReporter = function (navigationEvent) {
        if (navigationEvent.isInitial) {
            return pendingReport.promise();
        } else {
            return {};
        }
    };

    return spaTransitionReporter;
});