/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PluginMetadataUtil {
    private static XPathExpression createXPathExpression(String xpathExpression) throws XPathExpressionException {
        return XPathFactory.newInstance().newXPath().compile(xpathExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getPluginDescriptorDom(File pluginJar) throws IOException, ParserConfigurationException, SAXException {
        Document document;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry ze;
            zipInputStream = new ZipInputStream(new FileInputStream(pluginJar));
            while (null != (ze = zipInputStream.getNextEntry())) {
                if (!ze.getName().equalsIgnoreCase("atlassian-plugin.xml")) continue;
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = documentBuilder.parse(zipInputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipInputStream);
            throw throwable;
        }
        {
            IOUtils.closeQuietly((InputStream)zipInputStream);
            return document;
        }
        IOUtils.closeQuietly((InputStream)zipInputStream);
        return null;
    }

    public static String getPluginName(Document pluginDescriptor) throws XPathExpressionException {
        XPathExpression xPathExpression = PluginMetadataUtil.createXPathExpression("//atlassian-plugin/@name");
        return xPathExpression.evaluate(pluginDescriptor.getDocumentElement());
    }

    public static String getPluginKey(Document pluginDescriptor) throws XPathExpressionException {
        XPathExpression xPathExpression = PluginMetadataUtil.createXPathExpression("//atlassian-plugin/@key");
        return xPathExpression.evaluate(pluginDescriptor.getDocumentElement());
    }
}

