/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.helper;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.ContentHelper;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemoteComment;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.commons.lang.StringUtils;

public class CommentHelper
extends ContentHelper {
    private long parentId;
    private long contentId;
    private String lastModifier;
    private Date lastModifiedDate;

    public CommentHelper(ConfluenceWebTester confluenceWebTester, long id) {
        super(confluenceWebTester);
        this.setId(id);
    }

    public CommentHelper(ConfluenceWebTester confluenceWebTester) {
        this(confluenceWebTester, 0L);
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    protected RemoteComment toRemoteComment() {
        RemoteComment remoteComment = new RemoteComment();
        remoteComment.setId(this.getId());
        remoteComment.setPageId(this.getContentId());
        remoteComment.setParentId(this.getParentId());
        remoteComment.setContent(this.getContent());
        remoteComment.setCreator(StringUtils.isBlank((String)this.getCreator()) ? this.confluenceWebTester.getCurrentUserName() : this.getCreator());
        if (null != this.getCreationDate()) {
            Calendar creationDate = Calendar.getInstance();
            creationDate.setTime(this.getCreationDate());
            remoteComment.setCreated(creationDate);
        }
        remoteComment.setModifier(StringUtils.isBlank((String)this.getLastModifier()) ? this.confluenceWebTester.getCurrentUserName() : this.getLastModifier());
        if (null != this.getLastModifiedDate()) {
            Calendar lastModifiedDate = Calendar.getInstance();
            lastModifiedDate.setTime(this.getLastModifiedDate());
            remoteComment.setModified(lastModifiedDate);
        }
        return remoteComment;
    }

    protected void populateHelper(RemoteComment remoteComment) {
        this.setId(remoteComment.getId());
        this.setParentId(remoteComment.getParentId());
        this.setContentId(remoteComment.getPageId());
        this.setContent(remoteComment.getContent());
        this.setCreator(remoteComment.getCreator());
        this.setCreationDate(remoteComment.getCreated().getTime());
        this.setLastModifier(remoteComment.getModifier());
        this.setLastModifiedDate(remoteComment.getModified().getTime());
    }

    protected boolean storeRemoteContentAndUpdateHelper(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        if (0L >= this.getContentId()) {
            throw new IllegalStateException("Comment persistence not allowed if contentId is lesser or equals to zero.");
        }
        if (0L != this.getId()) {
            throw new IllegalStateException("At the time this method was written, we still do not have the ability to update comments via RPC. Therefore, I'm throwing this exception until we do.");
        }
        RemoteComment storedRemoteComment = confluenceSoapService.addComment(soapSessionToken, this.toRemoteComment());
        this.setId(storedRemoteComment.getId());
        return 0L < this.getId();
    }

    protected boolean readRemoteContentAndUpdateHelper(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        RemoteComment remoteComment = confluenceSoapService.getComment(soapSessionToken, this.getId());
        boolean success = null != remoteComment;
        if (success) {
            this.populateHelper(remoteComment);
        }
        return success;
    }

    protected boolean deleteRemoteContent(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        return confluenceSoapService.removeComment(soapSessionToken, this.getId());
    }
}

