/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.helper;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.AbstractSpaceContentHelper;
import com.atlassian.confluence.plugin.functest.helper.Attachable;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemoteAttachment;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemoteBlogEntry;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class BlogPostHelper
extends AbstractSpaceContentHelper
implements Attachable {
    private static final Logger LOG = Logger.getLogger(BlogPostHelper.class);

    public BlogPostHelper(ConfluenceWebTester confluenceWebTester, long id) {
        super(confluenceWebTester, id);
    }

    public BlogPostHelper(ConfluenceWebTester confluenceWebTester) {
        this(confluenceWebTester, 0L);
    }

    protected RemoteBlogEntry toRemoteBlogEntry() {
        RemoteBlogEntry remoteBlogEntry = new RemoteBlogEntry();
        Calendar creationDate = Calendar.getInstance();
        remoteBlogEntry.setId(this.getId());
        remoteBlogEntry.setSpace(this.getSpaceKey());
        remoteBlogEntry.setTitle(this.getTitle());
        remoteBlogEntry.setVersion(this.getVersion());
        remoteBlogEntry.setContent(this.getContent());
        remoteBlogEntry.setAuthor(StringUtils.isBlank((String)this.getCreator()) ? this.confluenceWebTester.getCurrentUserName() : this.getCreator());
        creationDate.setTime(this.getCreationDate());
        remoteBlogEntry.setPublishDate(creationDate);
        return remoteBlogEntry;
    }

    protected void populateHelper(RemoteBlogEntry remoteBlogEntry) {
        this.setId(remoteBlogEntry.getId());
        this.setSpaceKey(remoteBlogEntry.getSpace());
        this.setTitle(remoteBlogEntry.getTitle());
        this.setVersion(remoteBlogEntry.getVersion());
        this.setContent(remoteBlogEntry.getContent());
        this.setCreator(remoteBlogEntry.getAuthor());
        this.setCreationDate(remoteBlogEntry.getPublishDate().getTime());
    }

    protected boolean storeRemoteContentAndUpdateHelper(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        RemoteBlogEntry remoteBlogEntry = confluenceSoapService.storeBlogEntry(soapSessionToken, this.toRemoteBlogEntry());
        this.setId(remoteBlogEntry.getId());
        this.setVersion(remoteBlogEntry.getVersion());
        return 0L < this.getId();
    }

    protected boolean readRemoteContentAndUpdateHelper(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        RemoteBlogEntry remoteBlogEntry = confluenceSoapService.getBlogEntry(soapSessionToken, this.getId());
        boolean success = null != remoteBlogEntry;
        if (success) {
            this.populateHelper(remoteBlogEntry);
        }
        return success;
    }

    protected boolean deleteRemoteContent(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        return confluenceSoapService.removePage(soapSessionToken, this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttachmentFileNames() {
        String soapSessionToken = null;
        try {
            String[] attachmentNames;
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemoteAttachment[] remoteAttachments = confluenceSoapService.getAttachments(soapSessionToken, this.getId());
            if (null != remoteAttachments) {
                attachmentNames = new String[remoteAttachments.length];
                for (int i = 0; i < remoteAttachments.length; ++i) {
                    attachmentNames[i] = remoteAttachments[i].getFileName();
                }
            } else {
                attachmentNames = new String[]{};
            }
            String[] stringArray = attachmentNames;
            return stringArray;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findBySpaceKeyPublishedDateAndBlogPostTitle() {
        String authenticationToken = null;
        try {
            authenticationToken = this.confluenceWebTester.loginToXmlRPcService();
            XmlRpcClient xmlRpcClient = this.confluenceWebTester.getXmlRpcClient();
            String blogPostId = (String)xmlRpcClient.execute("functest-blogpost.getBlogPostId", new Vector<Serializable>(Arrays.asList(authenticationToken, this.getSpaceKey(), this.getTitle(), this.getCreationDate())));
            long l = StringUtils.isBlank((String)blogPostId) ? 0L : Long.parseLong(blogPostId);
            return l;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (XmlRpcException xmlRpcE) {
            LOG.error((Object)"Service request denied.", (Throwable)xmlRpcE);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
        }
        return 0L;
    }
}

