/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.BuildInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TesterConfiguration {
    private static final Logger LOG = Logger.getLogger(TesterConfiguration.class);
    private static final int DEFAULT_CONFLUENCE_WEBAPP_PORT = 1990;
    private String protocol;
    private String hostName;
    private int port;
    private String contextPath;
    private String adminUserName;
    private String adminPassword;
    private File pluginJar;
    private File testLibraryJar;
    private File siteBackupZip;
    private String license;
    private boolean installPlugin;

    public TesterConfiguration(Properties testProperties) throws IOException {
        this.initConfiguration(testProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TesterConfiguration() throws IOException {
        InputStream testPropertiesInput = this.getClass().getClassLoader().getResourceAsStream("webtester.properties");
        Properties testProperties = new Properties();
        if (null != testPropertiesInput) {
            try {
                testProperties.load(testPropertiesInput);
            }
            finally {
                IOUtils.closeQuietly((InputStream)testPropertiesInput);
            }
        } else {
            LOG.debug((Object)"Cannot find webtester.properties in the class path. Defaults specified in https://developer.atlassian.com/jira/browse/CONFPLUGTEST-13 will be used.");
        }
        this.initConfiguration(testProperties);
    }

    private void initConfiguration(Properties testProperties) throws IOException {
        String bundledPluginProperty;
        this.protocol = StringUtils.trim((String)StringUtils.defaultString((String)testProperties.getProperty("confluence.webapp.protocol"), (String)"http"));
        this.hostName = StringUtils.trim((String)StringUtils.defaultString((String)testProperties.getProperty("confluence.webapp.host"), (String)"localhost"));
        this.port = this.parsePort(StringUtils.trim((String)StringUtils.defaultString((String)System.getProperty("http.port"), (String)testProperties.getProperty("confluence.webapp.port"))));
        this.contextPath = this.parseContextPath(StringUtils.trim((String)StringUtils.defaultString((String)System.getProperty("context.path"), (String)StringUtils.defaultString((String)testProperties.getProperty("confluence.webapp.context.path"), (String)"/confluence"))));
        this.adminUserName = StringUtils.trim((String)StringUtils.defaultString((String)testProperties.getProperty("confluence.auth.admin.username"), (String)"admin"));
        this.adminPassword = StringUtils.trim((String)StringUtils.defaultString((String)testProperties.getProperty("confluence.auth.admin.password"), (String)"admin"));
        String pluginJarPath = StringUtils.trim((String)testProperties.getProperty("confluence.plugin.jar"));
        if (StringUtils.isNotBlank((String)pluginJarPath)) {
            this.pluginJar = this.parsePluginJar(pluginJarPath);
        }
        this.installPlugin = null != (bundledPluginProperty = StringUtils.trim((String)testProperties.getProperty("confluence.plugin.bundled"))) && !BooleanUtils.toBoolean((String)bundledPluginProperty);
        this.testLibraryJar = this.parseTestLibraryJar(this.getMavenRepositoryPath());
        String siteBackupZipPath = testProperties.getProperty("confluence.data.export");
        if (StringUtils.isNotBlank((String)siteBackupZipPath)) {
            this.siteBackupZip = this.parseSiteBackupZip(siteBackupZipPath);
        }
        this.license = this.readLicense();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getBaseUrl() {
        StringBuilder baseUrlBuilder = new StringBuilder(this.protocol).append("://").append(this.hostName);
        if (this.port != 80) {
            baseUrlBuilder.append(":").append(this.port);
        }
        return baseUrlBuilder.append(this.contextPath).toString();
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public File getPluginJar() {
        return this.pluginJar;
    }

    public boolean isInstallPlugin() {
        return this.installPlugin;
    }

    public File getTestLibraryJar() {
        return this.testLibraryJar;
    }

    public File getSiteBackupZip() {
        return this.siteBackupZip;
    }

    public String getLicense() {
        return this.license;
    }

    private int parsePort(String portString) {
        try {
            int thePort = Integer.parseInt(portString);
            return 0 > thePort ? 1990 : thePort;
        }
        catch (NumberFormatException nfe) {
            return 1990;
        }
    }

    private String parseContextPath(String contextPath) {
        return contextPath.equals("/") ? "" : contextPath;
    }

    private File parsePluginJar(String pluginJarLocation) {
        File pluginJar = new File(pluginJarLocation);
        return pluginJar.isFile() ? pluginJar : null;
    }

    private File parseTestLibraryJar(String localMavenRepositoryLocation) {
        File testLibraryJar = new File(localMavenRepositoryLocation, StringUtils.replace((String)BuildInfo.getGroupId(), (String)".", (String)"/") + '/' + BuildInfo.getArtifactId() + '/' + BuildInfo.getVersion() + '/' + BuildInfo.getArtifactId() + '-' + BuildInfo.getVersion() + ".jar");
        boolean testLibraryJarExists = testLibraryJar.isFile();
        LOG.info((Object)("Checking if test library can be found at: " + testLibraryJar.getAbsolutePath() + ": " + testLibraryJarExists));
        return testLibraryJarExists ? testLibraryJar : null;
    }

    private File parseSiteBackupZip(String siteBackupZipLocation) {
        File siteBackupZip = new File(siteBackupZipLocation);
        return siteBackupZip.isFile() ? siteBackupZip : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLicense() throws IOException {
        InputStream licenseInput = this.getClass().getClassLoader().getResourceAsStream("license.txt");
        if (null != licenseInput) {
            InputStreamReader licenseReader = new InputStreamReader(licenseInput, "UTF-8");
            StringWriter licenseWriter = new StringWriter();
            try {
                IOUtils.copy((Reader)licenseReader, (Writer)licenseWriter);
                String string = ((Object)licenseWriter).toString();
                return string;
            }
            finally {
                IOUtils.closeQuietly((Writer)licenseWriter);
                IOUtils.closeQuietly((Reader)licenseReader);
            }
        }
        return null;
    }

    private Document parseFileToDocument(File file) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        catch (ParserConfigurationException pce) {
            LOG.error((Object)"Unable to get XML parser.", (Throwable)pce);
        }
        catch (SAXException saxe) {
            LOG.error((Object)("Unable to parse " + file + " as XML"), (Throwable)saxe);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to read " + file));
        }
        return null;
    }

    private Document getGlobalMavenConfiguration() {
        File globalMavenSettingsFile = new File(System.getenv("M2_HOME"), "conf/settings.xml");
        return globalMavenSettingsFile.isFile() ? this.parseFileToDocument(globalMavenSettingsFile) : null;
    }

    private Document getUserMavenConfiguration() {
        File userMavenSettingsFile = new File(SystemUtils.getUserHome(), ".m2/settings.xml");
        return userMavenSettingsFile.isFile() ? this.parseFileToDocument(userMavenSettingsFile) : null;
    }

    private String getMavenLocalRepositoryPath(Document mavenSettings) {
        try {
            XPathExpression xPathExpression = XPathFactory.newInstance().newXPath().compile("//settings/localRepository/text()");
            return StringUtils.trim((String)xPathExpression.evaluate(mavenSettings));
        }
        catch (XPathExpressionException xee) {
            LOG.error((Object)"Unable to get /settings/localRepository from Document", (Throwable)xee);
            return null;
        }
    }

    private String getMavenRepositoryPath() {
        Document userMavenConfig = this.getUserMavenConfiguration();
        Document globalMavenConfig = this.getGlobalMavenConfiguration();
        String repositoryPath = null;
        if (null != userMavenConfig) {
            repositoryPath = this.getMavenLocalRepositoryPath(userMavenConfig);
        }
        if (StringUtils.isBlank(repositoryPath) && null != globalMavenConfig) {
            repositoryPath = this.getMavenLocalRepositoryPath(globalMavenConfig);
        }
        return StringUtils.isBlank((String)repositoryPath) ? new File(SystemUtils.getUserHome(), ".m2/repository").getAbsolutePath() : repositoryPath;
    }
}

