/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.module.xmlrpc.mail;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.jmx.JmxSMTPMailServer;
import com.atlassian.confluence.plugin.functest.module.xmlrpc.mail.MailServerHelperService;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.user.User;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MailServerHelperServiceDelegate
implements MailServerHelperService {
    private PermissionManager permissionManager;
    private BandanaManager bandanaManager;

    public MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public BandanaManager getBandanaManager() {
        return this.bandanaManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    private boolean isCurrentUserAnAdmin() {
        User user = AuthenticatedUserThreadLocal.getUser();
        return null != user && this.getPermissionManager().hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    private SMTPMailServer toSMTPMailServer(Map mailServerStructure) throws RemoteException {
        JmxSMTPMailServer smtpMailServer = new JmxSMTPMailServer(new Long((String)mailServerStructure.get("id")), (String)mailServerStructure.get("name"), null, (String)mailServerStructure.get("fromAddress"), (String)mailServerStructure.get("prefix"), StringUtils.isNotBlank((String)((String)mailServerStructure.get("jndiLocation"))), (String)mailServerStructure.get("jndiLocation"), (String)mailServerStructure.get("userName"), (String)mailServerStructure.get("password"));
        String[] smtpServerAddressParts = StringUtils.split((String)((String)mailServerStructure.get("address")), (char)':');
        if (smtpServerAddressParts.length == 1) {
            smtpMailServer.setHostname(smtpServerAddressParts[0]);
            smtpMailServer.setSmtpPort("25");
        } else if (smtpServerAddressParts.length == 2) {
            smtpMailServer.setHostname(smtpServerAddressParts[0]);
            smtpMailServer.setSmtpPort(smtpServerAddressParts[1]);
        } else {
            throw new RemoteException("Invalid address specified: " + mailServerStructure.get("address"));
        }
        return smtpMailServer;
    }

    private Hashtable toHashtable(SMTPMailServer smtpMailServer) throws RemoteException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (null != smtpMailServer.getId()) {
            hashtable.put("id", String.valueOf(smtpMailServer.getId()));
        }
        if (null != smtpMailServer.getName()) {
            hashtable.put("name", smtpMailServer.getName());
        }
        if (null != smtpMailServer.getDefaultFrom()) {
            hashtable.put("fromAddress", smtpMailServer.getDefaultFrom());
        }
        if (null != smtpMailServer.getPrefix()) {
            hashtable.put("prefix", smtpMailServer.getPrefix());
        }
        if (null != smtpMailServer.getJndiLocation()) {
            hashtable.put("jndiLocation", smtpMailServer.getJndiLocation());
        }
        if (null != smtpMailServer.getUsername()) {
            hashtable.put("userName", smtpMailServer.getUsername());
        }
        if (null != smtpMailServer.getPassword()) {
            hashtable.put("password", smtpMailServer.getPassword());
        }
        if (null != smtpMailServer.getHostname() && null != smtpMailServer.getSmtpPort()) {
            hashtable.put("address", smtpMailServer.getHostname() + ":" + smtpMailServer.getSmtpPort());
        }
        return hashtable;
    }

    private void validateMailServer(SMTPMailServer smtpMailServer) throws RemoteException {
        if (StringUtils.isBlank((String)smtpMailServer.getName())) {
            throw new RemoteException("Mail server name not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getDefaultFrom())) {
            throw new RemoteException("From address not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getPrefix())) {
            throw new RemoteException("Prefix not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getHostname()) && StringUtils.isBlank((String)smtpMailServer.getJndiLocation())) {
            throw new RemoteException("Server address/JNDI location not specified.");
        }
    }

    private Map getMailServersMap() {
        LinkedHashMap mailServersMap = (LinkedHashMap)this.getBandanaManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.smtp.mail.accounts");
        if (null == mailServersMap) {
            mailServersMap = new LinkedHashMap();
        }
        return mailServersMap;
    }

    private void persistMailServersMap(Map mailServersMap) {
        this.getBandanaManager().setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.smtp.mail.accounts", (Object)mailServersMap);
    }

    public String createMailServer(String authToken, Hashtable mailServerStructure) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        SMTPMailServer smtpMailServer = this.toSMTPMailServer(mailServerStructure);
        this.validateMailServer(smtpMailServer);
        smtpMailServer.setId(new Long(System.currentTimeMillis()));
        Map mailServersMap = this.getMailServersMap();
        mailServersMap.put(smtpMailServer.getId(), smtpMailServer);
        this.persistMailServersMap(mailServersMap);
        return smtpMailServer.getId().toString();
    }

    public boolean updateMailServer(String authToken, Hashtable mailServerStructure) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        SMTPMailServer smtpMailServer = this.toSMTPMailServer(mailServerStructure);
        Long mailServerId = smtpMailServer.getId();
        Map mailServersMap = this.getMailServersMap();
        mailServersMap.put(mailServerId, smtpMailServer);
        this.persistMailServersMap(mailServersMap);
        return true;
    }

    public Hashtable readMailServer(String authToken, String mailServerId) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        Long mailServerIdLong = new Long(mailServerId);
        Map mailServersMap = this.getMailServersMap();
        SMTPMailServer smtpMailServer = (SMTPMailServer)mailServersMap.get(mailServerIdLong);
        return null != smtpMailServer ? this.toHashtable(smtpMailServer) : null;
    }

    public boolean deleteMailServer(String authToken, String mailServerId) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        Long mailServerIdLong = new Long(mailServerId);
        Map mailServersMap = this.getMailServersMap();
        mailServersMap.remove(mailServerIdLong);
        this.persistMailServersMap(mailServersMap);
        return true;
    }

    public Hashtable getMailServerIdsAndNames(String authToken) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        Map mailServersMap = this.getMailServersMap();
        Hashtable<String, String> idsToNamesMap = new Hashtable<String, String>(mailServersMap.size());
        Iterator mapEntryIterator = mailServersMap.entrySet().iterator();
        while (mapEntryIterator.hasNext()) {
            Map.Entry e = mapEntryIterator.next();
            idsToNamesMap.put(e.getKey().toString(), ((SMTPMailServer)e.getValue()).getName());
        }
        return idsToNamesMap;
    }

    public String login(String s, String s1) throws RemoteException {
        return null;
    }

    public boolean logout(String s) throws RemoteException {
        return false;
    }
}

