/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.module.xmlrpc.blog;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.functest.module.xmlrpc.blog.BlogPostHelperService;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class BlogPostHelperServiceDelegate
implements BlogPostHelperService {
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private UserAccessor userAccessor;

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public String login(String s, String s1) throws RemoteException {
        return null;
    }

    public boolean logout(String s) throws RemoteException {
        return false;
    }

    private TimeZone getUserTimeZone() {
        String timeZoneId;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (null != user && StringUtils.isNotBlank((String)(timeZoneId = this.getUserAccessor().getUserPreferences(user).getString("confluence.user.time.zone")))) {
            return TimeZone.getTimeZone(timeZoneId);
        }
        return TimeZone.getDefault();
    }

    public String getBlogPostId(String authenticationToken, String spaceKey, String title, Date day) throws RemoteException {
        if (StringUtils.isBlank((String)spaceKey)) {
            throw new RemoteException("Space key not specified.");
        }
        if (StringUtils.isBlank((String)title)) {
            throw new RemoteException("Blog post title not specified.");
        }
        if (null == day) {
            throw new RemoteException("Blog post publish date not specified.");
        }
        Calendar _day = Calendar.getInstance(this.getUserTimeZone());
        _day.setTime(day);
        BlogPost blogPost = this.getPageManager().getBlogPost(spaceKey, title, _day);
        return null != blogPost && this.getPermissionManager().hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)blogPost) ? blogPost.getIdAsString() : null;
    }
}

