/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.HelperFactory;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapServiceServiceLocator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import junit.framework.Assert;
import net.sourceforge.jwebunit.junit.WebTester;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class JWebUnitConfluenceWebTester
extends WebTester
implements ConfluenceWebTester {
    private static final Logger LOG = Logger.getLogger((Class)JWebUnitConfluenceWebTester.class);
    private final String protocol;
    private final String hostName;
    private final int port;
    private final String contextPath;
    private final String adminUserName;
    private final String adminPassword;
    private String currentUserName;
    private String currentPassword;
    private File confluencePluginJar;
    private String confluencePluginName;
    private File confluenceBackupZip;
    private String licenseString;

    public JWebUnitConfluenceWebTester(String protocol, String hostName, int port, String contextPath, String adminUserName, String adminPassword) {
        this.protocol = protocol;
        this.hostName = hostName;
        this.port = port;
        this.contextPath = null != contextPath && contextPath.trim().equals("/") ? "" : contextPath;
        this.adminUserName = adminUserName;
        this.adminPassword = adminPassword;
        this.setCurrentUserName(adminUserName);
        this.setCurrentPassword(adminPassword);
        this.getTestContext().setBaseUrl(this.getBaseUrl());
        this.setScriptingEnabled(false);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getBaseUrl() {
        StringBuffer baseUrlBuffer = new StringBuffer(this.getProtocol()).append("://").append(this.getHostName());
        if (80 != this.getPort()) {
            baseUrlBuffer.append(':').append(this.getPort());
        }
        baseUrlBuffer.append(this.getContextPath());
        return baseUrlBuffer.toString();
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public void login(String username, String password) {
        this.setCurrentUserName(username);
        this.setCurrentPassword(password);
        this.login();
    }

    public void login() {
        this.gotoPage("/login.action");
        this.assertTextNotPresent("You are currently logged in");
        this.setWorkingForm("loginform");
        this.setTextField("os_username", this.getCurrentUserName());
        this.setTextField("os_password", this.getCurrentPassword());
        this.submit("login");
        this.assertLinkPresentWithText("Log Out");
    }

    public void logout() {
        this.gotoPage("/logout.action");
        this.assertTextPresent("You have been successfully logged out and any automatic logins removed.");
    }

    public XmlRpcClient getXmlRpcClient() throws MalformedURLException {
        return new XmlRpcClient(this.getBaseUrl() + "/rpc/xmlrpc");
    }

    public ConfluenceSoapService getConfluenceSoapService() throws MalformedURLException, ServiceException {
        ConfluenceSoapServiceServiceLocator confluenceSoapServiceServiceLocator = new ConfluenceSoapServiceServiceLocator();
        return confluenceSoapServiceServiceLocator.getConfluenceserviceV1(new URL(this.getBaseUrl() + "/rpc/soap-axis/confluenceservice-v1?wsdl"));
    }

    public String loginToXmlRpcService(String userName, String password) throws XmlRpcException, IOException {
        XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
        return (String)xmlRpcClient.execute("confluence1.login", new Vector<String>(Arrays.asList(userName, password)));
    }

    public void logoutFromXmlRpcService(String authenticationToken) {
        if (StringUtils.isNotBlank((String)authenticationToken)) {
            try {
                XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
                xmlRpcClient.execute("confluence1.logout", new Vector<String>(Arrays.asList(authenticationToken)));
            }
            catch (MalformedURLException mUrlE) {
                LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
            }
            catch (XmlRpcException xmlRpcE) {
                LOG.error((Object)"Service request denied.", (Throwable)xmlRpcE);
            }
            catch (RemoteException re) {
                LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
            }
        }
    }

    public String loginToXmlRPcService() throws XmlRpcException, IOException {
        return this.loginToXmlRpcService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    public String loginToSoapService(String userName, String password) throws MalformedURLException, ServiceException, RemoteException {
        ConfluenceSoapService confluenceSoapService = this.getConfluenceSoapService();
        return StringUtils.isNotBlank((String)userName) ? confluenceSoapService.login(userName, password) : null;
    }

    public String loginToSoapService() throws MalformedURLException, ServiceException, RemoteException {
        return this.loginToSoapService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    public void logoutFromSoapService(String authenticationToken) {
        try {
            if (null != authenticationToken) {
                this.getConfluenceSoapService().logout(authenticationToken);
            }
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
    }

    public void updateLicense() throws IOException {
        String licenseString = this.getLicenseString();
        if (StringUtils.isNotBlank((String)licenseString)) {
            this.gotoPage("/admin/console.action");
            this.clickLinkWithText("License Details");
            this.setWorkingForm("updateLicenseForm");
            this.setTextField("licenseString", licenseString);
            this.submit("update");
            this.assertTextNotPresent("License string is too short");
            this.assertTextNotPresent("License was not valid");
        }
    }

    public void refreshLicense() {
        this.gotoPage("/admin/refreshlicensing.action");
    }

    public void installPlugin() {
        File confluencePluginJar = this.getConfluencePluginJar();
        if (null != confluencePluginJar && confluencePluginJar.isFile()) {
            this.gotoPage("/admin/console.action");
            this.clickLinkWithText("Plugins");
            this.assertTextPresent("Manage Plugins");
            this.setWorkingForm("plugin-upload");
            this.setTextField("file_0", this.getConfluencePluginJar().getAbsolutePath());
            this.submit("confirm");
            this.assertLinkPresentWithText(this.getConfluencePluginName());
        }
    }

    public void restoreData() {
        File confluenceBackupZip = this.getConfluenceBackupZip();
        if (null != confluenceBackupZip && confluenceBackupZip.isFile()) {
            this.gotoPage("/admin/backup.action?synchronous=true");
            this.assertTextPresent("Restore Confluence Data");
            this.setWorkingForm(2);
            this.setTextField("file", confluenceBackupZip.getAbsolutePath());
            this.submit();
            HelperFactory.createIndexHelper(this).update();
        }
    }

    public void flushCaches() {
        this.gotoPage("/admin/console.action");
        this.clickLinkWithText("Cache Statistics");
        this.clickLinkWithText("Flush all");
    }

    public File getConfluencePluginJar() {
        return this.confluencePluginJar;
    }

    public void setConfluencePluginJar(File confluencePluginJar) {
        this.confluencePluginJar = confluencePluginJar;
    }

    public String getConfluencePluginName() {
        return this.confluencePluginName;
    }

    public void setConfluencePluginName(String confluencePluginName) {
        this.confluencePluginName = confluencePluginName;
    }

    public File getConfluenceBackupZip() {
        return this.confluenceBackupZip;
    }

    public void setConfluenceBackupZip(File confluenceBackupZip) {
        this.confluenceBackupZip = confluenceBackupZip;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String assertXsrfStatusCode(String resourcePath) {
        StringBuffer urlWithOsAuthTypeReplaced = new StringBuffer(this.getBaseUrl()).append(resourcePath.replaceAll("(.*[?&])(os_authType=\\w*)(.*)", "$1os_authType=basic$3"));
        if (urlWithOsAuthTypeReplaced.indexOf("os_authType") < 0) {
            urlWithOsAuthTypeReplaced.append(urlWithOsAuthTypeReplaced.indexOf("?") < 0 ? (char)'?' : '&').append("os_authType=basic");
        }
        HttpClient client = new HttpClient();
        GetMethod httpGet = new GetMethod(urlWithOsAuthTypeReplaced.toString());
        try {
            client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.getCurrentUserName(), this.getCurrentPassword()));
            httpGet.setDoAuthentication(true);
            Assert.assertEquals((int)403, (int)client.executeMethod((HttpMethod)httpGet));
            String string = httpGet.getResponseBodyAsString();
            return string;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error getting HTTP resource " + urlWithOsAuthTypeReplaced), (Throwable)ioe);
            String string = null;
            return string;
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public void assertResourceXsrfProtected(String resourcePath) {
        Assert.assertFalse((String)("No body text returned for " + resourcePath), (boolean)StringUtils.isBlank((String)this.assertXsrfStatusCode(resourcePath)));
    }

    public void assertXsrfTokenNotPresentFailure(String resourcePath) {
        Assert.assertTrue((this.assertXsrfStatusCode(resourcePath).indexOf("a required security token was not present") >= 0 ? 1 : 0) != 0);
    }

    public void assertXsrfTokenNotValidFailure(String resourcePath) {
        Assert.assertTrue((this.assertXsrfStatusCode(resourcePath).indexOf("Your session has expired. You may need to re-submit the form or reload the page.") >= 0 ? 1 : 0) != 0);
    }
}

