package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

import javax.xml.rpc.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;


public interface ConfluenceWebTester
{
    String getAdminUserName();

    String getAdminPassword();

    String getProtocol();

    String getHostName();

    int getPort();

    String getContextPath();

    String getCurrentUserName();

    void setCurrentUserName(String currentUserName);

    String getCurrentPassword();

    void setCurrentPassword(String currentPassword);

    File getConfluencePluginJar();

    void setConfluencePluginJar(File confluencePluginJar);

    String getConfluencePluginName();

    void setConfluencePluginName(String confluencePluginName);

    File getConfluenceBackupZip();

    void setConfluenceBackupZip(File confluenceBackupZip);

    String getLicenseString();

    void setLicenseString(String licenseString);

    String getBaseUrl();

    void login(final String username, final String password);

    void login();

    void logout();

    XmlRpcClient getXmlRpcClient() throws MalformedURLException;

    String loginToXmlRpcService(final String userName, final String password) throws XmlRpcException, IOException;

    void logoutFromXmlRpcService(final String authenticationToken);

    String loginToXmlRPcService() throws XmlRpcException, IOException;

    ConfluenceSoapService getConfluenceSoapService() throws MalformedURLException, ServiceException;

    String loginToSoapService(final String userName, final String password)
            throws MalformedURLException, ServiceException, RemoteException;

    String loginToSoapService() throws MalformedURLException, ServiceException, RemoteException;

    void logoutFromSoapService(final String authenticationToken);

    void updateLicense() throws IOException;

    void refreshLicense();

    void installPlugin();

    void restoreData();

    void flushCaches();

    /**
     * Asserts that a resource is XSRF protected.
     *
     * @param resourcePath The resource to test for XSRF protection. It must not contain the XSRF token. Must be absolute (e.g. <tt>/admin/plugins.action</tt>).
     */
    void assertResourceXsrfProtected(String resourcePath);

    void assertXsrfTokenNotPresentFailure(String resourcePath);

    void assertXsrfTokenNotValidFailure(String resourcePath);
}
