package com.atlassian.confluence.plugin.helper;

import org.apache.commons.lang.StringUtils;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MailServerHelper extends AbstractHelper {

    private long id;

    private String name;

    private String fromAddress;

    private String prefix;

    private String address;

    private String userName;

    private String password;

    private String jndiLocation;

    public MailServerHelper() {
        this(0);
    }

    public MailServerHelper(final long id) {
        setId(id);
        setPrefix("[confluence]");
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFromAddress() {
        return fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getAddress() {
        return null == address
                ? null
                : (address.indexOf(":") < 0 ? address + ":25" : address);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getJndiLocation() {
        return jndiLocation;
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = jndiLocation;
    }

    private void fromMap(final Map mailServerStructure) {
        setId(Long.parseLong((String) mailServerStructure.get("id")));
        setName((String) mailServerStructure.get("name"));
        setFromAddress((String) mailServerStructure.get("fromAddress"));
        setPrefix((String) mailServerStructure.get("prefix"));
        setJndiLocation((String) mailServerStructure.get("jndiLocation"));
        setUserName((String) mailServerStructure.get("userName"));
        setPassword((String) mailServerStructure.get("password"));
        setAddress((String) mailServerStructure.get("address"));
    }

    private Map toMap() {
        final Hashtable hashtable = new Hashtable();

        hashtable.put("id", String.valueOf(getId()));
        if (null != getName())
            hashtable.put("name", getName());
        if (null != getFromAddress())
            hashtable.put("fromAddress", getFromAddress());
        if (null != getPrefix())
            hashtable.put("prefix", getPrefix());
        if (null != getJndiLocation())
            hashtable.put("jndiLocation", getJndiLocation());
        if (null != getUserName())
            hashtable.put("userName", getUserName());
        if (null != getPassword())
            hashtable.put("password", getPassword());
        if (null != getAddress())
            hashtable.put("address", getAddress());

        return hashtable;
    }

    public Map getMailServerIdMap() {
        String authenticationToken = null;

        try {
            final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();

            authenticationToken = confluenceWebTester.loginToXmlRPcService();
            return (Map) xmlRpcClient.execute("functest-mailserver.getMailServerIdsAndNames",
                    new Vector(
                            Arrays.asList(
                                    new String[] {
                                            authenticationToken
                                    }
                            )
                    ));

        } catch (final MalformedURLException mUrlE) {
            handleInvalidXmlRpcServiceEndpointException(mUrlE);
        } catch (final XmlRpcException xre) {
            handleInvalidXmlRpcServiceException(xre);
        } catch (final IOException ioe) {
            handleIOException(ioe);
        } finally {
            confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
        }

        return Collections.EMPTY_MAP;
    }

    public List getMailServerIdsByName() {
        final List mailServerIds = new ArrayList();
        final Map mailServerIdMap = getMailServerIdMap();

        for (final Iterator i = mailServerIdMap.entrySet().iterator(); i.hasNext();) {
            final Map.Entry e = (Map.Entry) i.next();

            if (StringUtils.equals((String) e.getValue(), getName()))
                mailServerIds.add(new Long((String) e.getKey()));
        }

        return mailServerIds;
    }

    public boolean create() {
        String authenticationToken = null;

        try {
            final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();
            final long mailServerId;

            authenticationToken = confluenceWebTester.loginToXmlRPcService();
            mailServerId = Long.parseLong((String) xmlRpcClient.execute("functest-mailserver.createMailServer",
                    new Vector(
                            Arrays.asList(
                                    new Object[] {
                                            authenticationToken,
                                            toMap()
                                    }
                            )
                    )));

            setId(mailServerId);
            return true;

        } catch (final MalformedURLException mUrlE) {
            handleInvalidXmlRpcServiceEndpointException(mUrlE);
        } catch (final XmlRpcException xre) {
            handleInvalidXmlRpcServiceException(xre);
        } catch (final IOException ioe) {
            handleIOException(ioe);
        } finally {
            confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
        }

        return false;
    }

    public boolean update() {
        if (0 < getId()) {
            String authenticationToken = null;

            try {
                final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();
                final Boolean result;

                authenticationToken = confluenceWebTester.loginToXmlRPcService();
                result = (Boolean) xmlRpcClient.execute("functest-mailserver.updateMailServer",
                        new Vector(
                                Arrays.asList(
                                        new Object[] {
                                                authenticationToken,
                                                toMap()
                                        }
                                )
                        ));
                
                return result.booleanValue();

            } catch (final MalformedURLException mUrlE) {
                handleInvalidXmlRpcServiceEndpointException(mUrlE);
            } catch (final XmlRpcException xre) {
                handleInvalidXmlRpcServiceException(xre);
            } catch (final IOException ioe) {
                handleIOException(ioe);
            } finally {
                confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
            }
        }

        return false;
    }

    public boolean read() {
        if (0 < getId()) {
            String authenticationToken = null;

            try {
                final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();
                final Map mailServerStruct;

                authenticationToken = confluenceWebTester.loginToXmlRPcService();
                mailServerStruct = (Map) xmlRpcClient.execute("functest-mailserver.readMailServer",
                        new Vector(
                                Arrays.asList(
                                        new Object[] {
                                                authenticationToken,
                                                String.valueOf(getId())
                                        }
                                )
                        ));

                fromMap(mailServerStruct);

                return true;

            } catch (final MalformedURLException mUrlE) {
                handleInvalidXmlRpcServiceEndpointException(mUrlE);
            } catch (final XmlRpcException xre) {
                handleInvalidXmlRpcServiceException(xre);
            } catch (final IOException ioe) {
                handleIOException(ioe);
            } finally {
                confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
            }
        }

        return false;
    }

    public boolean delete() {
        if (0 < getId()) {
            String authenticationToken = null;

            try {
                final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();
                final Boolean result;

                authenticationToken = confluenceWebTester.loginToXmlRPcService();
                result = (Boolean) xmlRpcClient.execute("functest-mailserver.deleteMailServer",
                        new Vector(
                                Arrays.asList(
                                        new Object[] {
                                                authenticationToken,
                                                String.valueOf(getId())
                                        }
                                )
                        ));

                return result.booleanValue();

            } catch (final MalformedURLException mUrlE) {
                handleInvalidXmlRpcServiceEndpointException(mUrlE);
            } catch (final XmlRpcException xre) {
                handleInvalidXmlRpcServiceException(xre);
            } catch (final IOException ioe) {
                handleIOException(ioe);
            } finally {
                confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
            }
        }

        return false;
    }
}
