package com.atlassian.confluence.plugin.helper;

import org.apache.commons.lang.StringUtils;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

import java.util.Vector;
import java.util.Arrays;
import java.util.Map;
import java.net.MalformedURLException;
import java.io.IOException;

public class BandanaHelper extends AbstractHelper {

    private String bandanaKey;

    private String spaceKey = StringUtils.EMPTY;

    private String value;

    public BandanaHelper(final String spaceKey, final String key) {
        setSpaceKey(spaceKey);
        setBandanaKey(key);
    }

    public BandanaHelper(final String key) {
        this(StringUtils.EMPTY, key);
    }

    public String getBandanaKey() {
        return bandanaKey;
    }

    public void setBandanaKey(String bandanaKey) {
        this.bandanaKey = bandanaKey;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean create() {
        return update();
    }

    public boolean read() {
        String authenticationToken = null;

        try {
            final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();
            final Map bandanaEntry;

            authenticationToken = confluenceWebTester.loginToXmlRPcService();
            bandanaEntry = (Map) xmlRpcClient.execute("functest-bandana.getValue",
                    new Vector(
                            Arrays.asList(
                                    new Object[] {
                                            authenticationToken,
                                            StringUtils.defaultString(getSpaceKey()),
                                            StringUtils.defaultString(getBandanaKey())
                                    }
                            )
                    ));

            setSpaceKey((String) bandanaEntry.get("spaceKey"));
            setBandanaKey((String) bandanaEntry.get("key"));
            setValue((String) bandanaEntry.get("value"));

            return true;

        } catch (final MalformedURLException mUrlE) {
            handleInvalidXmlRpcServiceEndpointException(mUrlE);
        } catch (final XmlRpcException xre) {
            handleInvalidXmlRpcServiceException(xre);
        } catch (final IOException ioe) {
            handleIOException(ioe);
        } finally {
            confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
        }

        return false;
    }

    public boolean update() {
        String authenticationToken = null;

        try {
            final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();

            authenticationToken = confluenceWebTester.loginToXmlRPcService();
            return ((Boolean) xmlRpcClient.execute("functest-bandana.setValue",
                    new Vector(
                            Arrays.asList(
                                    new Object[] {
                                            authenticationToken,
                                            StringUtils.defaultString(getSpaceKey()),
                                            StringUtils.defaultString(getBandanaKey()),
                                            StringUtils.defaultString(getValue())
                                    }
                            )
                    ))).booleanValue();

        } catch (final MalformedURLException mUrlE) {
            handleInvalidXmlRpcServiceEndpointException(mUrlE);
        } catch (final XmlRpcException xre) {
            handleInvalidXmlRpcServiceException(xre);
        } catch (final IOException ioe) {
            handleIOException(ioe);
        } finally {
            confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
        }

        return false;
    }

    public boolean delete() {
        String authenticationToken = null;

        try {
            final XmlRpcClient xmlRpcClient = confluenceWebTester.getXmlRpcClient();

            authenticationToken = confluenceWebTester.loginToXmlRPcService();
            return ((Boolean) xmlRpcClient.execute("functest-bandana.removeValue",
                    new Vector(
                            Arrays.asList(
                                    new Object[] {
                                            authenticationToken,
                                            StringUtils.defaultString(getSpaceKey()),
                                            StringUtils.defaultString(getBandanaKey()),
                                    }
                            )
                    ))).booleanValue();

        } catch (final MalformedURLException mUrlE) {
            handleInvalidXmlRpcServiceEndpointException(mUrlE);
        } catch (final XmlRpcException xre) {
            handleInvalidXmlRpcServiceException(xre);
        } catch (final IOException ioe) {
            handleIOException(ioe);
        } finally {
            confluenceWebTester.logoutFromXmlRpcService(authenticationToken);
        }

        return false;
    }
}
