package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.RemoteComment;
import com.atlassian.confluence.RemoteLabel;

import javax.xml.rpc.ServiceException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSpaceContentHelper extends ContentHelper
        implements Labellable, Commentable {

    private String title;

    private String spaceKey;

    private List labels;

    protected AbstractSpaceContentHelper(final long id) {
        super(id);
        setLabels(new ArrayList());
    }

    protected AbstractSpaceContentHelper() {
        this(0);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public List getLabels() {
        return labels;
    }

    public void setLabels(List labels) {
        this.labels = labels;
    }

    public String getContentRendered() {
        String soapSessionToken = null;

        try {
            final ConfluenceSoapService confluenceSoapService;

            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            return confluenceSoapService.renderContent(
                    soapSessionToken, getSpaceKey(), getId(), getContent());

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return null;
    }

    public void markFavourite() {
        confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + getId());
        confluenceWebTester.assertTextPresent("addfavourite.action");

        confluenceWebTester.gotoPage("/labels/addfavourite.action?entityId=" + getId());
        confluenceWebTester.assertTextPresent("removefavourite.action");
    }

    public void addWatch() {
        confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + getId());
        confluenceWebTester.assertTextPresent("addpagenotification.action");

        confluenceWebTester.gotoPage("/pages/addpagenotification.action?pageId=" + getId());
        confluenceWebTester.assertTextPresent("removepagenotification");
    }

    public boolean isWatched() {
        confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + getId());
        return confluenceWebTester.getDialog().getResponseText().indexOf("removepagenotification.action") >= 0;
    }

    public boolean isFavorite() {
        confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + getId());
        return confluenceWebTester.getDialog().getResponseText().indexOf("removefavourite.action") >= 0;
    }

    public List getCommentIds() {
        if (0 < getId()) {
            final RemoteComment[] remoteComments;
            String soapSessionToken = null;
            ConfluenceSoapService confluenceSoapService;

            try {
                final List commentIds;

                soapSessionToken = confluenceWebTester.loginToSoapService();
                confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

                remoteComments = confluenceSoapService.getComments(soapSessionToken, getId());
                if (null != remoteComments) {
                    commentIds = new ArrayList(remoteComments.length);

                    for (int i = 0; i < remoteComments.length; ++i)
                        commentIds.add(new Long(remoteComments[i].getId()));

                    return commentIds;
                }

            } catch (final MalformedURLException mUrlE) {
                handleInvalidSoapServiceEndpointException(mUrlE);
            } catch (final ServiceException se) {
                handleInvalidSoapServiceException(se);
            } catch (final RemoteException re) {
                handleRemoteException(re);
            } finally {
                confluenceWebTester.logoutFromSoapService(soapSessionToken);
            }
        }

        return null;
    }

    protected List readLabels() throws RemoteException {
        if (0 != getId()) {
            String soapSessionToken = null;
            ConfluenceSoapService confluenceSoapService;

            try {
                final RemoteLabel[] remoteLabels;
                final List labels = new ArrayList();

                soapSessionToken = confluenceWebTester.loginToSoapService();
                confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

                remoteLabels = confluenceSoapService.getLabelsById(soapSessionToken, getId());

                if (null != remoteLabels) {
                    final StringBuffer labelBuffer = new StringBuffer();

                    for (int i = 0; i < remoteLabels.length; ++i) {
                        labelBuffer.setLength(0);

                        if (!"global".equals(remoteLabels[i].getNamespace()))
                            labelBuffer.append(remoteLabels[i].getNamespace()).append(':');

                        labelBuffer.append(remoteLabels[i].getName());
                        labels.add(labelBuffer.toString());
                    }
                }

                return labels;

            } catch (final MalformedURLException mUrlE) {
                handleInvalidSoapServiceEndpointException(mUrlE);
            } catch (final ServiceException se) {
                handleInvalidSoapServiceException(se);
            } catch (final RemoteException re) {
                handleRemoteException(re);
            } finally {
                confluenceWebTester.logoutFromSoapService(soapSessionToken);
            }
        }

        return Collections.EMPTY_LIST;
    }

    protected void updateLabels() throws RemoteException {
        if (0 != getId()) {
            final List remoteLabels = readLabels();

            String soapSessionToken = null;
            ConfluenceSoapService confluenceSoapService;

            try {
                soapSessionToken = confluenceWebTester.loginToSoapService();
                confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

                for (final Iterator i = getLabels().iterator(); i.hasNext();) {
                    final String label = (String) i.next();

                    if (!remoteLabels.contains(label))
                        confluenceSoapService.addLabelByName(soapSessionToken, label, getId());
                }

                for (final Iterator i = remoteLabels.iterator(); i.hasNext();) {
                    final String remoteLabel = (String) i.next();

                    if (!getLabels().contains(remoteLabel))
                        confluenceSoapService.removeLabelByName(soapSessionToken, remoteLabel, getId());
                }

            } catch (final MalformedURLException mUrlE) {
                handleInvalidSoapServiceEndpointException(mUrlE);
            } catch (final ServiceException se) {
                handleInvalidSoapServiceException(se);
            } catch (final RemoteException re) {
                handleRemoteException(re);
            } finally {
                confluenceWebTester.logoutFromSoapService(soapSessionToken);
            }
        }
    }

    protected boolean saveOrUpdate() {
        try {
            if (super.saveOrUpdate()) {
                updateLabels();
                return true;
            }
        } catch (final RemoteException re) {
            handleRemoteException(re);
        }

        return false;
    }

    public boolean read() {
        if (super.read()) {
            try {
                setLabels(readLabels());
                return true;
            } catch (final RemoteException re) {
                handleRemoteException(re);
            }
        }

        return false;
    }
}
