/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageCacheCleanupJobDetail;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.google.common.base.Throwables;
import java.text.ParseException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

@ExportAsService
@Named(value="cacheCleanupJobScheduler")
public class CacheCleanupJobScheduler
implements LifecycleAware {
    private static final String CRON_EXPRESSION = "0 0 2 * * ?";
    private final Scheduler scheduler;
    private final TimeZoneManager timeZoneManager;
    private final ImageCacheCleanupJobDetail imageCacheCleanupJobDetail;

    @Inject
    public CacheCleanupJobScheduler(@ComponentImport Scheduler scheduler, @ComponentImport TimeZoneManager timeZoneManager, ImageCacheCleanupJobDetail imageCacheCleanupJobDetail) {
        this.scheduler = Objects.requireNonNull(scheduler);
        this.timeZoneManager = Objects.requireNonNull(timeZoneManager);
        this.imageCacheCleanupJobDetail = Objects.requireNonNull(imageCacheCleanupJobDetail);
    }

    public void onStart() {
        try {
            CronTrigger trigger = new CronTrigger();
            trigger.setGroup(this.imageCacheCleanupJobDetail.getGroup());
            trigger.setName(this.imageCacheCleanupJobDetail.getName());
            trigger.setCronExpression(CRON_EXPRESSION);
            trigger.setTimeZone(this.timeZoneManager.getDefaultTimeZone());
            this.scheduler.scheduleJob((JobDetail)this.imageCacheCleanupJobDetail, (Trigger)trigger);
        }
        catch (ParseException | SchedulerException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void onStop() {
        try {
            this.scheduler.deleteJob(this.imageCacheCleanupJobDetail.getName(), this.imageCacheCleanupJobDetail.getGroup());
        }
        catch (SchedulerException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

