/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.ext.usage.UsagePeriod;
import com.atlassian.confluence.spaces.Space;
import java.util.Collection;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public class AbstractUsageQuery {
    protected String period = UsagePeriod.DAILY.name().toLowerCase();
    protected Collection<Space> spaces;
    protected Collection<String> eventTypes;
    protected String columns;
    protected Date[] timespan;

    protected Date[] getTimespan() {
        return this.timespan;
    }

    public Query getLuceneQuery() {
        BooleanQuery q = new BooleanQuery();
        if (!this.eventTypes.isEmpty()) {
            BooleanQuery eventsQuery = new BooleanQuery();
            for (String eventType : this.eventTypes) {
                eventsQuery.add((Query)new TermQuery(new Term("eventType", eventType)), BooleanClause.Occur.SHOULD);
            }
            q.add((Query)eventsQuery, BooleanClause.Occur.MUST);
        }
        if (!this.spaces.isEmpty()) {
            BooleanQuery spacesQuery = new BooleanQuery();
            for (Space space : this.spaces) {
                spacesQuery.add((Query)new TermQuery(new Term("space", Long.toString(space.getId()))), BooleanClause.Occur.SHOULD);
            }
            q.add((Query)spacesQuery, BooleanClause.Occur.MUST);
        }
        if (this.timespan != null && this.timespan.length == 2 && (this.timespan[0] != null || this.timespan[1] != null)) {
            Date lower = null;
            Date upper = null;
            if (this.timespan[0] != null) {
                lower = this.timespan[0];
            }
            if (this.timespan.length > 0 && this.timespan[1] != null) {
                upper = this.timespan[1];
            }
            q.add((Query)new TermRangeQuery("date", lower != null ? new BytesRef((CharSequence)DateTools.dateToString((Date)lower, (DateTools.Resolution)DateTools.Resolution.SECOND)) : null, upper != null ? new BytesRef((CharSequence)DateTools.dateToString((Date)upper, (DateTools.Resolution)DateTools.Resolution.SECOND)) : null, true, true), BooleanClause.Occur.MUST);
        }
        this.addBooleanClauses(q);
        if (q.getClauses().length == 0) {
            return new MatchAllDocsQuery();
        }
        return q;
    }

    protected void addBooleanClauses(BooleanQuery query) {
    }

    public String getPeriod() {
        return this.period;
    }

    public Collection<Space> getSpaces() {
        return this.spaces;
    }

    public Collection<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setSpaces(Collection<Space> spaces) {
        this.spaces = spaces;
    }

    public void setEventTypes(Collection<String> events) {
        this.eventTypes = events;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setTimespan(Date[] timespan) {
        this.timespan = timespan;
    }
}

