/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.index;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.Collection;

public class PopularResult
implements Comparable<PopularResult> {
    private String entityId;
    private String entityType;
    private int count;
    private Space space;
    private SpaceManager spaceManager;
    private ContentEntityManager contentEntityManager;
    private ContentEntityObject ceo;
    private Collection<Label> labels;

    public PopularResult(SpaceManager spaceManager, ContentEntityManager contentEntityManager, String entityId, String entityType) {
        this.contentEntityManager = contentEntityManager;
        this.spaceManager = spaceManager;
        this.entityId = entityId;
        this.entityType = entityType;
        this.count = 0;
    }

    public boolean isSpace() {
        return this.entityType.equals("space");
    }

    public boolean isPage() {
        return this.entityType.equals("page");
    }

    public boolean isComment() {
        return this.entityType.equals("comment");
    }

    public boolean isBlogPost() {
        return this.entityType.equals("blogpost");
    }

    public Space getSpace() {
        if (this.isSpace() && this.space == null && this.entityId != null) {
            this.space = this.spaceManager.getSpace(Long.parseLong(this.entityId));
        }
        return this.space;
    }

    public ContentEntityObject getContent() {
        if (this.isContent() && this.ceo == null && this.entityId != null) {
            this.ceo = this.contentEntityManager.getById(Long.parseLong(this.entityId));
        }
        return this.ceo;
    }

    public Collection<Label> getLabels() {
        if (this.isContent()) {
            this.labels = this.getContent().getLabels();
        }
        return this.labels;
    }

    public boolean isContent() {
        return this.isPage() || this.isComment() || this.isBlogPost();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    @Override
    public int compareTo(PopularResult popularResult) {
        if (popularResult.count > this.count) {
            return 1;
        }
        if (popularResult.count < this.count) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.entityType + ":" + this.entityId + "(" + this.count + ")";
    }
}

