/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.actions;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUsageReport
extends AbstractSpaceAction {
    public static final String PERIOD_DAY = "day";
    public static final String PERIOD_WEEK = "week";
    public static final String PERIOD_MONTH = "month";
    public static final String PARAM_DATE_FORMAT = "yyyyMMdd";
    public static final String CHART_PLUGIN_KEY = "confluence.extra.chart";
    private static final String INTERVAL_HOUR = "Hour";
    private static final String INTERVAL_DAY = "Day";
    private static final String MONTH_TITLE_FORMAT = "MMMM yyyy";
    private static final String DEFAULT_TITLE_FORMAT = "dd MMMM yyyy";
    private Date reportDate = new Date();
    private String period = "week";
    private int topItems = 10;

    public int getTopItems() {
        return this.topItems;
    }

    public void setTopItems(int topItems) {
        this.topItems = topItems;
    }

    public void setDate(String date) throws ParseException {
        try {
            this.setReportDate(this.getParameterDateFormat().parse(date));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String formatDateParam(Date date) {
        return this.getParameterDateFormat().format(date);
    }

    public Date getReportDate() {
        if (this.getPeriod().equals(PERIOD_WEEK)) {
            return this.getWeekStartDate();
        }
        if (this.getPeriod().equals(PERIOD_MONTH)) {
            return this.getMonthStartDate();
        }
        return this.reportDate;
    }

    public Date getNextReportDate() {
        return this.advanceReportDate(1);
    }

    public Date getPreviousReportDate() {
        return this.advanceReportDate(-1);
    }

    public String getPreviousReportDateParam() {
        return this.formatDateParam(this.getPreviousReportDate());
    }

    public String getNextReportDateParam() {
        return this.formatDateParam(this.getNextReportDate());
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public String getPeriod() {
        return this.period;
    }

    public String getPeriodName() {
        SimpleDateFormat format = new SimpleDateFormat(this.getTitleDateFormat());
        Object[] args = new Object[]{format.format(this.getReportDate())};
        return this.getText("usage.period." + this.getPeriod() + ".title", args);
    }

    public String getUsageTimespan() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        return dateFormat.format(this.getReportDate()) + "," + dateFormat.format(this.advanceReportDate(1));
    }

    public boolean isChartInstalled() {
        return this.pluginAccessor.isPluginEnabled(CHART_PLUGIN_KEY);
    }

    public String renderUsageMacro(String macro, String chartParams) {
        return this.getHelper().renderConfluenceMacro(this.chartIfAvailable(macro, chartParams));
    }

    public String chartIfAvailable(String tableMacro, String chartParams) {
        if (!this.isChartInstalled()) {
            return tableMacro;
        }
        return "{chart" + (StringUtils.isNotBlank((CharSequence)chartParams) ? ":" + chartParams : "") + "}" + tableMacro + "{chart}";
    }

    private String getTitleDateFormat() {
        if (PERIOD_MONTH.equals(this.getPeriod())) {
            return MONTH_TITLE_FORMAT;
        }
        return DEFAULT_TITLE_FORMAT;
    }

    private Date getWeekStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.reportDate);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    private Date advanceReportDate(int periods) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getReportDate());
        String period = this.getPeriod();
        if (PERIOD_WEEK.equals(period)) {
            calendar.add(5, periods * calendar.getMaximum(7));
        } else if (PERIOD_MONTH.equals(period)) {
            calendar.add(2, periods);
        } else if (PERIOD_DAY.equals(period)) {
            calendar.add(5, periods);
        }
        return calendar.getTime();
    }

    private Date getMonthStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.reportDate);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private DateFormat getParameterDateFormat() {
        return new SimpleDateFormat(PARAM_DATE_FORMAT);
    }

    public String getChartTimeInterval() {
        String period = this.getPeriod();
        if (PERIOD_DAY.equals(period)) {
            return INTERVAL_HOUR;
        }
        return INTERVAL_DAY;
    }
}

