package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.ext.usage.UsageConstants;
import com.atlassian.confluence.labels.Label;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;

import java.util.Collection;
import java.util.Iterator;

/**
 * A very simple usage query object
 */
public class ContentUsageQuery extends AbstractUsageQuery {
    private Collection<String> contentTypes;
    protected Collection<Label> labels;

    public ContentUsageQuery() {
    }

    public ContentUsageQuery(ContentUsageQuery q) {
        this.period = q.getPeriod();
        this.contentTypes = q.getContentTypes();
        this.spaces = q.getSpaces();
        this.labels = q.getLabels();
        this.eventTypes = q.getEventTypes();
        this.columns = q.getColumns();
        this.timespan = q.getTimespan();
    }

    protected void addBooleanClauses(BooleanQuery query) {
        if (!contentTypes.isEmpty()) {
            BooleanQuery typesQuery = new BooleanQuery();
            for (Iterator iterator = contentTypes.iterator(); iterator.hasNext(); ) {
                String contentType = (String) iterator.next();
                typesQuery.add(new TermQuery(new Term(UsageConstants.FIELD_ENTITYTYPE, contentType)), BooleanClause.Occur.SHOULD);
            }
            query.add(typesQuery, BooleanClause.Occur.MUST);
        }
    }

    public Collection<String> getContentTypes() {
        return contentTypes;
    }

    public void setContentTypes(Collection<String> types) {
        this.contentTypes = types;
    }

    public Collection<Label> getLabels() {
        return labels;
    }

    public void setLabels(Collection<Label> labels) {
        this.labels = labels;
    }
}
