package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.ext.usage.UsageConstants;
import com.atlassian.confluence.ext.usage.UsagePeriod;
import com.atlassian.confluence.spaces.Space;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

import java.util.Collection;
import java.util.Date;

public class AbstractUsageQuery {
    protected String period = UsagePeriod.DAILY.name().toLowerCase();
    protected Collection<Space> spaces;
    protected Collection<String> eventTypes;
    protected String columns;
    protected Date[] timespan;

    protected Date[] getTimespan() {
        return timespan;
    }

    public Query getLuceneQuery() {
        BooleanQuery q = new BooleanQuery();

        if (!eventTypes.isEmpty()) {
            BooleanQuery eventsQuery = new BooleanQuery();
            for (String eventType : eventTypes) {
                eventsQuery.add(new TermQuery(new Term(UsageConstants.FIELD_EVENTTYPE, eventType)), BooleanClause.Occur.SHOULD);
            }
            q.add(eventsQuery, BooleanClause.Occur.MUST);
        }

        if (!spaces.isEmpty()) {
            BooleanQuery spacesQuery = new BooleanQuery();
            for (Space space : spaces) {
                spacesQuery.add(new TermQuery(new Term(UsageConstants.FIELD_SPACEID, Long.toString(space.getId()))), BooleanClause.Occur.SHOULD);
            }
            q.add(spacesQuery, BooleanClause.Occur.MUST);
        }

        if (timespan != null && timespan.length == 2 && (timespan[0] != null || timespan[1] != null)) {
            Date lower = null;
            Date upper = null;

            if (timespan[0] != null)
                lower = timespan[0];

            if (timespan.length > 0 && timespan[1] != null)
                upper = timespan[1];

            q.add(new TermRangeQuery(UsageConstants.FIELD_DATE,
                    (lower != null ? new BytesRef(DateTools.dateToString(lower, DateTools.Resolution.SECOND)) : null),
                    (upper != null ? new BytesRef(DateTools.dateToString(upper, DateTools.Resolution.SECOND)) : null),
                    true, true), BooleanClause.Occur.MUST);
        }

        addBooleanClauses(q);

        if (q.getClauses().length == 0) {
            return new MatchAllDocsQuery();
        }

        return q;
    }

    protected void addBooleanClauses(BooleanQuery query) {

    }

    public String getPeriod() {
        return period;
    }

    public Collection<Space> getSpaces() {
        return spaces;
    }

    public Collection<String> getEventTypes() {
        return eventTypes;
    }

    public String getColumns() {
        return columns;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setSpaces(Collection<Space> spaces) {
        this.spaces = spaces;
    }

    public void setEventTypes(Collection<String> events) {
        this.eventTypes = events;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setTimespan(Date[] timespan) {
        this.timespan = timespan;
    }
}
